/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.PaintingEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class S2CUpdatePaintingData {
    public int paintingId;
    public int[] pixels;
    public int compositeHash;

    public S2CUpdatePaintingData(int id, int[] p, int hash) {
        this.paintingId = id;
        this.pixels = p;
        this.compositeHash = hash;
    }

    public static void encode(S2CUpdatePaintingData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.m_130089_(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static S2CUpdatePaintingData decode(FriendlyByteBuf packetBuffer) {
        int id = packetBuffer.readInt();
        int[] p = packetBuffer.m_130100_();
        int hash = packetBuffer.readInt();
        return new S2CUpdatePaintingData(id, p, hash);
    }

    public static void handle(S2CUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            Entity entity = world.m_6815_(msg.paintingId);
            if (entity instanceof PaintingEntity) {
                PaintingEntity pe = (PaintingEntity)entity;
                if (pe.data.getPaintingHash() != msg.compositeHash) {
                    pe.data.clearCache(pe.data.getPaintingHash());
                    pe.data.setPixels(msg.pixels);
                }
                pe.data.cache();
                System.out.println("Data Synced: " + String.valueOf(pe.data.getPaintingHash() == msg.compositeHash));
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

