/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import io.github.how_bout_no.outvoted.init.ModItems;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator generator) {
        super(generator);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((id, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)id, (LootTable)table));
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(ModEntityLootTables::new, (Object)LootParameterSets.field_216263_d));
    }

    public static class ModEntityLootTables
    extends EntityLootTables {
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> Optional.ofNullable(entity.getRegistryName()).filter(registryName -> registryName.func_110624_b().equals("outvoted")).isPresent()).collect(Collectors.toList());
        }

        protected void addTables() {
            this.func_218582_a((EntityType)ModEntityTypes.WILDFIRE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_151072_bj).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.WILDFIRE_PIECE.get())).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.15f, (float)0.05f))).func_212840_b_(KilledByPlayer.func_215994_b()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.WILDFIRE_HELMET.get())).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.025f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
            this.func_218582_a((EntityType)ModEntityTypes.HUNGER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_151062_by).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VOID_HEART.get())).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.1f, (float)0.05f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
            this.func_218582_a((EntityType)ModEntityTypes.KRAKEN.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.KRAKEN_TOOTH.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
        }
    }
}

