/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.data;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

class ShapelessBuilder
extends ShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;

    public ShapelessBuilder(IItemProvider resultIn, int countIn) {
        super(resultIn, countIn);
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public static ShapelessRecipeBuilder shapelessRecipe(IItemProvider resultIn) {
        return new ShapelessBuilder(resultIn, 1);
    }

    public static ShapelessRecipeBuilder shapelessRecipe(IItemProvider resultIn, int countIn) {
        return new ShapelessBuilder(resultIn, countIn);
    }

    public ShapelessRecipeBuilder func_203221_a(Tag<Item> tagIn) {
        return this.func_200489_a(Ingredient.func_199805_a(tagIn));
    }

    public ShapelessRecipeBuilder func_200487_b(IItemProvider itemIn) {
        return this.func_200491_b(itemIn, 1);
    }

    public ShapelessRecipeBuilder func_200491_b(IItemProvider itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
        }
        return this;
    }

    public ShapelessRecipeBuilder func_200489_a(Ingredient ingredientIn) {
        return this.func_200492_a(ingredientIn, 1);
    }

    public ShapelessRecipeBuilder func_200492_a(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public ShapelessRecipeBuilder func_200483_a(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public ShapelessRecipeBuilder func_200490_a(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void func_200482_a(Consumer<IFinishedRecipe> consumerIn) {
        this.func_200485_a(consumerIn, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void func_200484_a(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.func_200485_a(consumerIn, new ResourceLocation(save));
    }

    public void func_200485_a(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept((IFinishedRecipe)new ShapelessRecipeBuilder.Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/combat/" + id.func_110623_a())));
    }
}

