/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import com.google.common.collect.ImmutableList;
import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.init.ModItems;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.init.ModTags;
import io.github.how_bout_no.outvoted.util.EntityUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.InfinityEnchantment;
import net.minecraft.enchantment.MendingEnchantment;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AirItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Direction8;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.MutablePair;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class HungerEntity
extends CreatureEntity
implements IAnimatable {
    private static final DataParameter<Boolean> BURROWED = EntityDataManager.func_187226_a(HungerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(HungerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ENCHANTING = EntityDataManager.func_187226_a(HungerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(HungerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Map<Enchantment, Integer> storedEnchants = new HashMap<Enchantment, Integer>();
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        String animname;
        String string = animname = event.getController().getCurrentAnimation() != null ? event.getController().getCurrentAnimation().animationName : "";
        if (this.isBurrowed()) {
            if (this.isEnchanting()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("bite").addAnimation("biteloop", Boolean.valueOf(true)));
            } else if (event.getController().getCurrentAnimation() != null) {
                if (animname.equals("idle") || animname.equals("attacking") || animname.equals("chomp") || animname.equals("burrow")) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("burrow").addAnimation("burrowed", Boolean.valueOf(true)));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("burrowed", Boolean.valueOf(true)));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("burrow").addAnimation("burrowed", Boolean.valueOf(true)));
            }
        } else if (event.getController().getCurrentAnimation() == null || animname.equals("idle") || animname.equals("attacking")) {
            if (this.isAttacking()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
            }
        } else if (this.isAttacking()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("chomp").addAnimation("attacking"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("chomp").addAnimation("idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        if (event.sound.equals("chomp")) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.HUNGER_BITE.get(), this.func_184176_by(), 1.0f, 1.0f, false);
        } else if (event.sound.equals("dig")) {
            BlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 0.5, this.func_226281_cx_()));
            if (block.func_203425_a(BlockTags.field_203436_u)) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.HUNGER_DIG_SAND.get(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            } else {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.HUNGER_DIG.get(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    private <E extends IAnimatable> void particleListener(ParticleKeyFrameEvent<E> event) {
        if (event.effect.equals("dig")) {
            for (int i = 0; i < 2; ++i) {
                BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 0.5, this.func_226281_cx_());
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), this.func_226282_d_(0.5), this.func_226283_e_(0.0), this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate);
        controller.registerSoundListener(this::soundListener);
        controller.registerParticleListener(this::particleListener);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public HungerEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
        EntityUtils.setConfigHealth((LivingEntity)this, (Double)OutvotedConfig.COMMON.healthhunger.get());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(19.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BiteGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new BurrowGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FindSpotGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, true));
    }

    public static boolean canSpawn(EntityType<HungerEntity> entity, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_175710_j(blockPos) && HungerEntity.func_223315_a(entity, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random) && world.func_180495_p(blockPos.func_177977_b()).func_203425_a(ModTags.HUNGER_CAN_BURROW);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.HUNGER_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.HUNGER_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.HUNGER_DEATH.get();
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        ItemStack item = ItemStack.field_190927_a;
        EnchantmentHelper.func_82782_a(this.storedEnchants, (ItemStack)item);
        CompoundNBT compoundNBT = new CompoundNBT();
        item.func_77955_b(compoundNBT);
        compound.func_218657_a("Enchantments", (INBT)compoundNBT);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        ItemStack item = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Enchantments"));
        this.storedEnchants = EnchantmentHelper.func_226652_a_((ListNBT)item.func_77986_q());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Block block = worldIn.func_180495_p(this.func_226270_aj_()).func_177230_c();
        int type = Outvoted.matchesBlock(block, Blocks.field_150354_m) ? 0 : (Outvoted.matchesBlock(block, Blocks.field_196611_F) ? 1 : 2);
        this.setVariant(type);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BURROWED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ENCHANTING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void setBurrowed(boolean burrowed) {
        this.field_70180_af.func_187227_b(BURROWED, (Object)burrowed);
    }

    public boolean isBurrowed() {
        return (Boolean)this.field_70180_af.func_187225_a(BURROWED);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setEnchanting(boolean enchanting) {
        this.field_70180_af.func_187227_b(ENCHANTING, (Object)enchanting);
    }

    public boolean isEnchanting() {
        return (Boolean)this.field_70180_af.func_187225_a(ENCHANTING);
    }

    public void setVariant(int type) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)type);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private static boolean hasEnchantibility(ItemStack itemStack) {
        return itemStack.func_77956_u() || itemStack.func_77948_v() || itemStack.func_77973_b() instanceof EnchantedBookItem;
    }

    public MutablePair<Integer, ItemStack> modifyEnchantments(ItemStack stack, int damage, int count) {
        ItemStack itemstack = stack.func_77946_l();
        ConcurrentHashMap<Enchantment, Integer> cacheEnchants = new ConcurrentHashMap<Enchantment, Integer>(this.storedEnchants);
        itemstack.func_196083_e("Enchantments");
        itemstack.func_196083_e("StoredEnchantments");
        if (damage > 0) {
            itemstack.func_196085_b(damage);
        } else {
            itemstack.func_196083_e("Damage");
        }
        if (itemstack.func_77973_b() == Items.field_151122_aG) {
            itemstack = new ItemStack((IItemProvider)Items.field_151134_bR);
        }
        MutablePair pair = new MutablePair((Object)0, (Object)itemstack);
        if (this.storedEnchants.size() <= (Integer)OutvotedConfig.COMMON.max_enchants.get()) {
            itemstack.func_190920_e(count);
            boolean[] hasCurses = new boolean[]{false};
            Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(enchant -> {
                if (((Enchantment)enchant.getKey()).func_190936_d()) {
                    hasCurses[0] = true;
                }
                return !((Enchantment)enchant.getKey()).func_190936_d();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (hasCurses[0]) {
                this.func_195064_c(new EffectInstance(Effects.field_82731_v, 600, 1));
                pair.setLeft((Object)1);
                return pair;
            }
            if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("Bitten")) {
                pair.setLeft((Object)1);
                return pair;
            }
            if (!HungerEntity.hasEnchantibility(itemstack)) {
                pair.setRight((Object)ItemStack.field_190927_a);
                return pair;
            }
            if (itemstack.func_77973_b().equals(ModItems.VOID_HEART.get())) {
                return pair;
            }
            if (!map.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
                    Enchantment enchantment = entry.getKey();
                    Integer level = entry.getValue();
                    if (cacheEnchants.containsKey(enchantment)) {
                        if (enchantment.func_77325_b() != 1 && (Integer)cacheEnchants.get(enchantment) != enchantment.func_77325_b() + 1) {
                            if (level.intValue() == enchantment.func_77325_b() && ((Integer)cacheEnchants.get(enchantment)).intValue() == enchantment.func_77325_b()) {
                                for (Enchantment ench : cacheEnchants.keySet()) {
                                    if ((Integer)cacheEnchants.get(ench) != ench.func_77325_b() + 1) continue;
                                    pair.setLeft((Object)1);
                                    return pair;
                                }
                                cacheEnchants.put(enchantment, enchantment.func_77325_b() + 1);
                                continue;
                            }
                            if (level.equals(cacheEnchants.get(enchantment))) {
                                cacheEnchants.put(enchantment, level + 1);
                                continue;
                            }
                            if (level <= (Integer)cacheEnchants.get(enchantment)) continue;
                            cacheEnchants.put(enchantment, level);
                            continue;
                        }
                        pair.setLeft((Object)1);
                        return pair;
                    }
                    if (!this.storedEnchants.isEmpty()) {
                        for (Enchantment ench : this.storedEnchants.keySet()) {
                            if (enchantment instanceof ProtectionEnchantment && ench instanceof ProtectionEnchantment) {
                                if (((ProtectionEnchantment)enchantment).func_77326_a(ench)) {
                                    cacheEnchants.put(enchantment, level);
                                    continue;
                                }
                                pair.setLeft((Object)1);
                                return pair;
                            }
                            if (enchantment instanceof InfinityEnchantment || enchantment instanceof MendingEnchantment) {
                                cacheEnchants.put(enchantment, level);
                                continue;
                            }
                            if (enchantment instanceof DamageEnchantment && ench instanceof DamageEnchantment) {
                                cacheEnchants.put(enchantment, level);
                                continue;
                            }
                            if (enchantment.func_191560_c(ench)) {
                                cacheEnchants.put(enchantment, level);
                                continue;
                            }
                            pair.setLeft((Object)1);
                            return pair;
                        }
                        continue;
                    }
                    cacheEnchants.put(enchantment, level);
                }
            } else {
                if (!this.storedEnchants.isEmpty()) {
                    pair.setLeft((Object)2);
                    map = this.storedEnchants;
                    this.storedEnchants = new HashMap<Enchantment, Integer>();
                    EnchantmentHelper.func_82782_a(map, (ItemStack)itemstack);
                    return pair;
                }
                pair.setRight((Object)ItemStack.field_190927_a);
            }
            this.storedEnchants = cacheEnchants;
        } else {
            pair.setLeft((Object)1);
        }
        return pair;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) && !source.field_76373_n.equals("wither") && !source.func_82725_o() && !source.func_94541_c();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean exec = super.func_70652_k(entityIn);
        if (exec && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            ImmutableList allInventories = ImmutableList.of((Object)player.field_71071_by.field_70462_a, (Object)player.field_71071_by.field_70460_b, (Object)player.field_71071_by.field_184439_c);
            ArrayList<ItemStack> enchantedItems = new ArrayList<ItemStack>();
            for (NonNullList inv : allInventories) {
                enchantedItems.addAll(inv.stream().filter(item -> !EnchantmentHelper.func_82781_a((ItemStack)item).isEmpty()).collect(Collectors.toList()));
            }
            enchantedItems.removeIf(item -> item.func_77973_b() instanceof AirItem);
            if (!enchantedItems.isEmpty()) {
                ItemStack item2 = (ItemStack)enchantedItems.get(this.field_70146_Z.nextInt(enchantedItems.size()));
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)item2);
                item2.func_196083_e("Enchantments");
                item2.func_196083_e("StoredEnchantments");
                Object[] enchants = enchantments.keySet().toArray();
                Enchantment enchant = (Enchantment)enchants[this.field_70146_Z.nextInt(enchants.length)];
                if ((Integer)enchantments.get(enchant) > 1) {
                    enchantments.put(enchant, (Integer)enchantments.get(enchant) - 1);
                } else {
                    enchantments.remove(enchant);
                }
                if (enchantments.isEmpty() && item2.func_77973_b() instanceof EnchantedBookItem) {
                    for (NonNullList inv : allInventories) {
                        if (!inv.contains((Object)item2)) continue;
                        inv.set(inv.indexOf((Object)item2), (Object)new ItemStack((IItemProvider)Items.field_151122_aG));
                    }
                } else {
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)item2);
                }
            }
        }
        return exec;
    }

    public void func_70636_d() {
        if (this.func_70089_S()) {
            this.func_184224_h(this.isBurrowed());
        }
        super.func_70636_d();
    }

    public boolean func_70104_M() {
        return !this.func_190530_aW() && super.func_70104_M();
    }

    public boolean isSuitable(HungerEntity hungerIn, @Nullable BlockPos pos) {
        double posZ;
        double posY;
        double posX;
        if (this.func_70660_b(Effects.field_82731_v) != null) {
            return false;
        }
        World world = hungerIn.field_70170_p;
        if (pos == null) {
            posX = hungerIn.func_226277_ct_();
            posY = hungerIn.func_226278_cu_();
            posZ = hungerIn.func_226281_cx_();
        } else {
            posX = pos.func_177958_n();
            posY = pos.func_177956_o();
            posZ = pos.func_177952_p();
        }
        boolean ret = true;
        block0: for (double k = posX - 1.0; k <= posX + 1.0 && ret; k += 1.0) {
            for (double l = posZ - 1.0; l <= posZ + 1.0; l += 1.0) {
                BlockState block = world.func_180495_p(new BlockPos(k, posY - 1.0, l));
                if (block.func_203425_a(ModTags.HUNGER_CAN_BURROW) && !hungerIn.func_70090_H()) {
                    if (!ret) continue;
                    ret = !hungerIn.func_110167_bD();
                    continue;
                }
                ret = false;
                continue block0;
            }
        }
        return ret;
    }

    private Vec3d directionVector() {
        Vec3d vec3d = Vec3d.field_186680_a;
        double rotation = this.field_70177_z - 180.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        int ordinal = MathHelper.func_76128_c((double)(rotation / 45.0 + 0.5)) & 7;
        for (Direction direction : Direction8.values()[ordinal].func_197532_a()) {
            vec3d = vec3d.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
        }
        return vec3d;
    }

    static class LookGoal
    extends LookRandomlyGoal {
        private final HungerEntity hunger;

        public LookGoal(HungerEntity entitylivingIn) {
            super((MobEntity)entitylivingIn);
            this.hunger = entitylivingIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.hunger.isBurrowed();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.hunger.isBurrowed();
        }
    }

    static class BurrowGoal
    extends Goal {
        private final HungerEntity hunger;
        private int tick = 0;
        private ItemStack cacheitem = ItemStack.field_190927_a;

        public BurrowGoal(HungerEntity entityIn) {
            this.hunger = entityIn;
        }

        public boolean func_75250_a() {
            return !this.hunger.isAttacking() && this.hunger.isSuitable(this.hunger, null);
        }

        public boolean func_75253_b() {
            return !this.hunger.isAttacking() && this.hunger.isSuitable(this.hunger, null);
        }

        public void func_75249_e() {
            this.hunger.setBurrowed(true);
        }

        public void func_75251_c() {
            this.tick = 0;
            this.hunger.setBurrowed(false);
        }

        public void func_75246_d() {
            Vec3d vec3d = this.hunger.directionVector().func_186678_a(0.6);
            AxisAlignedBB boundingBox = this.hunger.func_174813_aQ().func_216361_a(vec3d).func_216361_a(vec3d.func_216371_e());
            List entities = this.hunger.field_70170_p.func_72839_b((Entity)this.hunger, boundingBox);
            if (!(entities.isEmpty() || this.hunger.isAttacking() || this.hunger.isEnchanting())) {
                for (Entity entity : entities) {
                    if (!boundingBox.func_72318_a(entity.func_213303_ch())) continue;
                    if (entity instanceof ItemEntity) {
                        ItemStack item = ((ItemEntity)entity).func_92059_d();
                        if (((ItemEntity)entity).func_200214_m() == this.hunger.func_110124_au()) continue;
                        this.cacheitem = item.func_77946_l();
                        this.hunger.field_70170_p.func_184148_a(null, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), (SoundEvent)ModSounds.HUNGER_EAT.get(), this.hunger.func_184176_by(), 0.8f, 0.9f);
                        entity.func_70106_y();
                        this.hunger.setEnchanting(true);
                        break;
                    }
                    if (!(entity instanceof LivingEntity) || !entity.func_70089_S() || !this.hunger.func_213336_c((LivingEntity)entity)) continue;
                    this.hunger.setBurrowed(false);
                    this.hunger.setAttacking(true);
                    this.hunger.func_70652_k(entity);
                }
            }
            if (this.hunger.isEnchanting()) {
                ++this.tick;
                if (this.tick % 16 == 0) {
                    ItemEntity newitem;
                    MutablePair<Integer, ItemStack> pair = this.hunger.modifyEnchantments(this.cacheitem, this.cacheitem.func_77952_i(), 1);
                    ItemStack item = (ItemStack)pair.getRight();
                    if (this.cacheitem.func_77973_b().equals(ModItems.VOID_HEART.get())) {
                        Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.hunger.field_70170_p, (Entity)this.hunger) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                        this.hunger.field_70170_p.func_217385_a((Entity)this.hunger, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), 2.0f, explosion$mode);
                        this.hunger.func_70106_y();
                    }
                    if ((Integer)pair.getLeft() == 0) {
                        if (item != ItemStack.field_190927_a) {
                            this.hunger.field_70170_p.func_184148_a(null, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), SoundEvents.field_187604_bf, this.hunger.func_184176_by(), 0.8f, 0.6f);
                        }
                    } else if ((Integer)pair.getLeft() == 1) {
                        this.hunger.field_70170_p.func_184148_a(null, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), (SoundEvent)ModSounds.HUNGER_SPIT.get(), this.hunger.func_184176_by(), 0.8f, 0.8f);
                        newitem = new ItemEntity(this.hunger.field_70170_p, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), this.cacheitem);
                        newitem.func_200216_c(this.hunger.func_110124_au());
                        this.hunger.field_70170_p.func_217376_c((Entity)newitem);
                    } else {
                        this.hunger.field_70170_p.func_184148_a(null, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), SoundEvents.field_187802_ec, this.hunger.func_184176_by(), 0.8f, 0.6f);
                        item.func_196082_o().func_74768_a("Bitten", 1);
                        newitem = new ItemEntity(this.hunger.field_70170_p, this.hunger.func_226277_ct_(), this.hunger.func_226278_cu_(), this.hunger.func_226281_cx_(), item);
                        newitem.func_200216_c(this.hunger.func_110124_au());
                        this.hunger.field_70170_p.func_217376_c((Entity)newitem);
                    }
                    this.cacheitem = ItemStack.field_190927_a;
                    this.tick = 0;
                    this.hunger.setEnchanting(false);
                }
            }
        }
    }

    static class WanderGoal
    extends WaterAvoidingRandomWalkingGoal {
        private final HungerEntity hunger;

        public WanderGoal(HungerEntity entityIn) {
            super((CreatureEntity)entityIn, 1.0, 0.1f);
            this.hunger = entityIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.hunger.isBurrowed() && !this.hunger.isSuitable(this.hunger, null);
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.hunger.isBurrowed() && !this.hunger.isSuitable(this.hunger, null);
        }

        public void func_75246_d() {
            if (this.hunger.isBurrowed() || this.hunger.isSuitable(this.hunger, null)) {
                this.field_75457_a.func_70661_as().func_75499_g();
            }
        }
    }

    static class FindSpotGoal
    extends Goal {
        protected final HungerEntity hunger;
        private double spotX;
        private double spotY;
        private double spotZ;
        private final double movementSpeed;

        public FindSpotGoal(HungerEntity theCreatureIn, double movementSpeedIn) {
            this.hunger = theCreatureIn;
            this.movementSpeed = movementSpeedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.isPossibleSpot() && this.hunger.func_70638_az() == null && !this.hunger.isBurrowed() && !this.hunger.isSuitable(this.hunger, null);
        }

        protected boolean isPossibleSpot() {
            Vec3d vector3d = this.findPossibleSpot();
            if (vector3d == null) {
                return false;
            }
            this.spotX = vector3d.field_72450_a;
            this.spotY = vector3d.field_72448_b;
            this.spotZ = vector3d.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !this.hunger.func_70661_as().func_75500_f() && !this.hunger.isBurrowed();
        }

        public void func_75249_e() {
            this.hunger.func_70661_as().func_75492_a(this.spotX, this.spotY, this.spotZ, this.movementSpeed);
        }

        public void func_75251_c() {
            this.hunger.func_70661_as().func_75499_g();
        }

        public static Vec3d copyCenteredHorizontally(Vec3i toCopy) {
            return new Vec3d((double)toCopy.func_177958_n() + 0.5, (double)toCopy.func_177956_o(), (double)toCopy.func_177952_p() + 0.5);
        }

        @Nullable
        protected Vec3d findPossibleSpot() {
            Random random = this.hunger.func_70681_au();
            BlockPos blockpos = this.hunger.func_180425_c();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
                if (!this.hunger.isSuitable(this.hunger, blockpos1) || !(this.hunger.func_180484_a(blockpos1) < 0.0f)) continue;
                return FindSpotGoal.copyCenteredHorizontally((Vec3i)blockpos1);
            }
            return null;
        }
    }

    static class BiteGoal
    extends MeleeAttackGoal {
        private final HungerEntity hunger;

        public BiteGoal(HungerEntity entityIn, double speedIn, boolean useMemory) {
            super((CreatureEntity)entityIn, speedIn, useMemory);
            this.hunger = entityIn;
        }

        public boolean func_75250_a() {
            this.hunger.setAttacking(this.hunger.func_70638_az() != null && !this.hunger.isBurrowed());
            return super.func_75250_a() && this.hunger.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !this.hunger.isBurrowed();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.hunger.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !this.hunger.isBurrowed();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.hunger.setAttacking(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.hunger.setAttacking(this.field_75441_b.func_70638_az() != null);
        }
    }
}

