/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.util.EntityUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class KrakenEntity
extends MonsterEntity
implements IAnimatable {
    private static final DataParameter<Integer> ATTACKING = EntityDataManager.func_187226_a(KrakenEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(KrakenEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity targetedEntity;
    private static Map<Integer, UUID> targetedEntities = new HashMap<Integer, UUID>();
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    protected RandomWalkingGoal wander;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public KrakenEntity(EntityType<? extends KrakenEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        EntityUtils.setConfigHealth((LivingEntity)this, (Double)OutvotedConfig.COMMON.healthkraken.get());
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttackPhase() != 0) {
            if (this.hasTargetedEntity()) {
                GeckoLibCache.getInstance().parser.setValue("distance", this.func_70068_e((Entity)this.getTargetedEntity()) + 15.0);
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack").addAnimation("reelin"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("swim"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_184651_r() {
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0);
        this.wander = new RandomWalkingGoal((CreatureEntity)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChaseGoal(this, 6.0, 48.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, KrakenEntity.class, 72.0f, 4.0, 4.0));
        this.field_70714_bg.func_75776_a(6, (Goal)movetowardsrestrictiongoal);
        this.field_70714_bg.func_75776_a(7, (Goal)this.wander);
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.wander.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static boolean canSpawn(EntityType<KrakenEntity> entity, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return (double)blockPos.func_177956_o() <= 45.0;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected void updateAir(int air) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 5.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public int getAttackDuration() {
        return 80;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    private void setAttacking(int attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getAttackPhase() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public int func_70627_aG() {
        return 160;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.KRAKEN_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.KRAKEN_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.KRAKEN_DEATH.get();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.4f;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) ? 10.0f + worldIn.func_205052_D(pos) - 0.5f : super.func_205022_a(pos, worldIn);
    }

    public void func_70645_a(DamageSource cause) {
        targetedEntities.remove(this.field_70180_af.func_187225_a(TARGET_ENTITY));
        super.func_70645_a(cause);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.func_70653_a(entityIn, strength / 4.0f, xRatio, zRatio);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            if (this.field_70170_p.field_72995_K) {
                if (!this.func_70090_H()) {
                    Vec3d vector3d = this.func_213322_ci();
                    if (vector3d.field_72448_b > 0.0 && this.clientSideTouchedGround && !this.func_174814_R()) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getFlopSound(), this.func_184176_by(), 1.0f, 1.0f, false);
                    }
                    boolean bl = this.clientSideTouchedGround = vector3d.field_72448_b < 0.0 && this.field_70170_p.func_217400_a(this.func_180425_c().func_177977_b(), (Entity)this);
                }
                if (this.hasTargetedEntity() && this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
            }
            if (this.hasTargetedEntity()) {
                this.field_70177_z = this.field_70759_as;
                LivingEntity livingentity = this.getTargetedEntity();
                if (livingentity != null) {
                    this.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
                    this.func_70671_ap().func_75649_a();
                    double d5 = this.getAttackAnimationScale(0.0f);
                    double d0 = livingentity.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = livingentity.func_226283_e_(0.5) - this.func_226280_cw_();
                    double d2 = livingentity.func_226281_cx_() - this.func_226281_cx_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_70146_Z.nextDouble();
                    if (this.getAttackPhase() == 0) {
                        this.setAttacking(1);
                    }
                    while (d4 < d3) {
                        d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5);
                        livingentity.func_70012_b(this.func_226277_ct_() + d0 * d3, this.func_226280_cw_() + d1, this.func_226281_cx_() + d2 * d3, livingentity.field_70177_z, livingentity.field_70125_A);
                        livingentity.func_204711_a(false);
                        livingentity.func_205343_av();
                        if (!this.field_70170_p.field_72995_K && livingentity.func_184218_aH() && livingentity.func_184208_bv() instanceof BoatEntity) {
                            Entity boat = livingentity.func_184208_bv();
                            livingentity.func_184210_p();
                            boat.func_199703_a((IItemProvider)((BoatEntity)boat).func_184455_j());
                            try {
                                InventoryHelper.func_180176_a((World)boat.field_70170_p, (Entity)boat, (IInventory)((IInventory)boat));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boat.func_70106_y();
                        }
                        if (this.getAttackPhase() == 0) continue;
                        livingentity.func_70024_g(-d0 / 50.0, -d1 / 50.0, -d2 / 50.0);
                    }
                }
            }
            if (this.func_203005_aq()) {
                this.func_70050_g(300);
            } else if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f)));
                this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                this.field_70122_E = false;
                this.field_70160_al = true;
            }
        }
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)ModSounds.KRAKEN_FLOP.get();
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.wander != null) {
            this.wander.func_179480_f();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213352_e(Vec3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70689_ay() == 0.0f && this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.001, 0.0));
            } else if (this.func_70638_az() != null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_213394_dL()) {
            this.func_213390_a(this.func_180425_c(), 96);
        }
    }

    public boolean waterCheck(LivingEntity livingentity) {
        if (livingentity.func_184187_bx() != null) {
            return livingentity.func_184187_bx().func_70090_H();
        }
        return livingentity.func_70090_H() && livingentity.func_70660_b(Effects.field_206827_D) == null && (targetedEntities.get(livingentity.func_145782_y()) == null || targetedEntities.get(livingentity.func_145782_y()) == this.func_110124_au());
    }

    static class MoveHelperController
    extends MovementController {
        private final KrakenEntity entity;

        public MoveHelperController(KrakenEntity entity) {
            super((MobEntity)entity);
            this.entity = entity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.entity.func_70661_as().func_75500_f()) {
                Vec3d vector3d = new Vec3d(this.field_75646_b - this.entity.func_226277_ct_(), this.field_75647_c - this.entity.func_226278_cu_(), this.field_75644_d - this.entity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                double d1 = vector3d.field_72450_a / d0;
                double d2 = vector3d.field_72448_b / d0;
                double d3 = vector3d.field_72449_c / d0;
                float f = (float)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.entity.field_70761_aq = this.entity.field_70177_z = this.func_75639_a(this.entity.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.entity.func_70689_ay(), (float)f1);
                this.entity.func_70659_e(f2);
                double d4 = Math.sin((double)(this.entity.field_70173_aa + this.entity.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entity.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entity.field_70177_z * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.entity.field_70173_aa + this.entity.func_145782_y()) * 0.75) * 0.05;
                this.entity.func_213317_d(this.entity.func_213322_ci().func_72441_c(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookController lookcontroller = this.entity.func_70671_ap();
                double d8 = this.entity.func_226277_ct_() + d1 * 2.0;
                double d9 = this.entity.func_226280_cw_() + d2 / d0;
                double d10 = this.entity.func_226281_cx_() + d3 * 2.0;
                double d11 = lookcontroller.func_180423_e();
                double d12 = lookcontroller.func_180422_f();
                double d13 = lookcontroller.func_180421_g();
                if (!lookcontroller.func_180424_b()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.entity.func_70671_ap().func_75650_a(MathHelper.func_219803_d((double)0.125, (double)d11, (double)d8), MathHelper.func_219803_d((double)0.125, (double)d12, (double)d9), MathHelper.func_219803_d((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.entity.func_70659_e(0.0f);
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final KrakenEntity entity;
        private int tickCounter;

        public AttackGoal(KrakenEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.entity.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.entity.waterCheck(livingentity) && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) < 64.0;
        }

        public boolean func_75253_b() {
            if (this.entity.func_70638_az() != null) {
                return this.entity.func_70068_e((Entity)this.entity.func_70638_az()) < 90.5 && this.entity.func_70638_az().func_70660_b(Effects.field_206827_D) == null && this.entity.waterCheck(this.entity.func_70638_az());
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 90.0f, 90.0f);
            this.entity.field_70160_al = true;
        }

        public void func_75251_c() {
            targetedEntities.remove(this.entity.field_70180_af.func_187225_a(TARGET_ENTITY));
            this.entity.setTargetedEntity(0);
            this.entity.func_70624_b(null);
            this.entity.wander.func_179480_f();
            this.entity.setAttacking(0);
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                this.entity.func_70661_as().func_75499_g();
                this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
                if (!this.entity.func_70685_l((Entity)livingentity)) {
                    this.entity.func_70624_b(null);
                } else {
                    ++this.tickCounter;
                    this.entity.setAttacking(1);
                    if (this.tickCounter == 0) {
                        this.entity.setTargetedEntity(this.entity.func_70638_az().func_145782_y());
                        targetedEntities.put(livingentity.func_145782_y(), this.entity.func_110124_au());
                    } else if (this.tickCounter >= this.entity.getAttackDuration() && this.tickCounter % 20 == 0) {
                        if (livingentity.func_70660_b(Effects.field_76427_o) != null && livingentity.func_70086_ai() == 0) {
                            livingentity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                        }
                        livingentity.func_70050_g(Math.max(livingentity.func_70086_ai() - 45, 0));
                    }
                }
            }
        }
    }

    static class ChaseGoal
    extends MoveTowardsTargetGoal {
        private final KrakenEntity entity;
        private final double speed;

        public ChaseGoal(KrakenEntity kraken, double speedIn, float maxDistanceIn) {
            super((CreatureEntity)kraken, speedIn, maxDistanceIn);
            this.entity = kraken;
            this.speed = speedIn;
        }

        public void func_75251_c() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                return super.func_75250_a() && this.entity.waterCheck(livingentity) && this.entity.func_213383_dH();
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                return super.func_75253_b() && this.entity.waterCheck(livingentity) && this.entity.func_213383_dH();
            }
            return false;
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.speed);
            }
        }
    }
}

