/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.entity.WildfireFireballEntity;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.util.EntityUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildfireEntity
extends MonsterEntity
implements IAnimatable {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private boolean shieldDisabled = false;
    private static final DataParameter<Boolean> SHIELDING = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(WildfireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        String animname;
        String string = animname = event.getController().getCurrentAnimation() != null ? event.getController().getCurrentAnimation().animationName : "";
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) || !animname.equals("attack")) {
            if (this.getAttacking()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("attack"));
            } else if (this.getShielding()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("shieldtransition").addAnimation("shielding"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("generaltransition").addAnimation("general"));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public WildfireEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 20;
        EntityUtils.setConfigHealth((LivingEntity)this, (Double)OutvotedConfig.COMMON.healthwildfire.get());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.WILDFIRE_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.WILDFIRE_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.WILDFIRE_HURT.get();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.8f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Block block = worldIn.func_180495_p(new BlockPos(this.func_213303_ch().func_72441_c(0.0, -0.5, 0.0))).func_177230_c();
        int type = Outvoted.matchesBlock(block, Blocks.field_150425_aM) ? 1 : 0;
        this.setVariant(type);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void setShielding(boolean shielding) {
        if (!this.shieldDisabled) {
            this.field_70180_af.func_187227_b(SHIELDING, (Object)shielding);
        } else {
            this.field_70180_af.func_187227_b(SHIELDING, (Object)false);
        }
    }

    public boolean getShielding() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDING) != false && !this.shieldDisabled;
    }

    public void setVariant(int type) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)type);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public boolean getAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, (SoundEvent)ModSounds.WILDFIRE_BURN.get(), this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.getShielding()) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.getAttacking()) {
            for (int particlei = 0; particlei < 16; ++particlei) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.75), this.func_226279_cv_(), this.func_226287_g_(0.75), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public boolean isWaterSensitive() {
        return true;
    }

    protected void func_70619_bc() {
        LivingEntity livingentity;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * (3.0f / (this.func_110143_aJ() / 25.0f + 1.0f));
        }
        if ((livingentity = this.func_70638_az()) != null && livingentity.func_226280_cw_() > this.func_226280_cw_() + (double)this.heightOffset && this.func_213336_c(livingentity)) {
            Vec3d vector3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vector3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70027_ad() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    private void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            double itemDamage;
            LivingEntity entity;
            if (source.func_76364_f() instanceof LivingEntity && this.func_190530_aW() && (entity = (LivingEntity)source.func_76364_f()).func_184614_ca().func_77973_b() instanceof AxeItem && (double)amount >= (itemDamage = ((AttributeModifier)((AxeItem)entity.func_184614_ca().func_77973_b()).func_111205_h(EquipmentSlotType.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).iterator().next()).func_111164_d() + 1.0) + itemDamage / 2.0) {
                this.func_184185_a(SoundEvents.field_187692_g, 0.3f, 1.5f);
                this.shieldDisabled = true;
                this.setShielding(false);
                this.func_184224_h(false);
                return false;
            }
            if (this.func_180431_b(source)) {
                this.func_184185_a(SoundEvents.field_187692_g, 0.3f, 0.5f);
                if (source.func_76352_a()) {
                    source.func_76364_f().func_70015_d(12);
                } else if (source.func_76364_f() != null) {
                    source.func_76364_f().func_70015_d(8);
                }
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_180431_b(DamageSource source) {
        if ((source == DamageSource.field_76377_j || source instanceof EntityDamageSource) && !source.func_180136_u()) {
            return this.func_190530_aW();
        }
        return false;
    }

    static class AttackGoal
    extends Goal {
        private final WildfireEntity wildfire;
        private int attackStep;
        private int attackTime;
        private int firedRecentlyTimer;

        public AttackGoal(WildfireEntity wildfireIn) {
            this.wildfire = wildfireIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.wildfire.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.wildfire.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.wildfire.setOnFire(false);
            this.wildfire.setShielding(false);
            this.wildfire.setAttacking(false);
            this.firedRecentlyTimer = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.wildfire.func_70638_az();
            this.wildfire.setAttacking(false);
            if (livingentity != null) {
                boolean flag = this.wildfire.func_70635_at().func_75522_a((Entity)livingentity);
                this.firedRecentlyTimer = flag ? 0 : ++this.firedRecentlyTimer;
                double d0 = this.wildfire.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    this.wildfire.setOnFire(true);
                    if (this.attackTime <= 0) {
                        this.wildfire.setAttacking(true);
                        this.attackTime = 5;
                        this.wildfire.func_70652_k((Entity)livingentity);
                        livingentity.func_70015_d(4);
                    }
                    this.wildfire.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.wildfire.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.wildfire.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.wildfire.func_226281_cx_();
                    float health = (this.wildfire.func_110138_aP() - this.wildfire.func_110143_aJ()) / 2.0f;
                    float healthPercent = this.wildfire.func_110143_aJ() / this.wildfire.func_110138_aP();
                    int maxAttackSteps = 3;
                    if (d0 < 36.0) {
                        ++maxAttackSteps;
                    }
                    if ((double)healthPercent < 0.6) {
                        ++maxAttackSteps;
                    }
                    if (this.attackTime <= 0) {
                        this.wildfire.setShielding(false);
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = (int)(40.0f * healthPercent + 20.0f);
                            this.wildfire.setOnFire(true);
                        } else if (this.attackStep <= maxAttackSteps) {
                            this.attackTime = (int)(25.0f * healthPercent + 5.0f);
                        } else {
                            this.attackTime = 200;
                            this.attackStep = 0;
                            this.wildfire.setOnFire(false);
                            this.wildfire.setAttacking(false);
                        }
                        if (this.attackStep > 1) {
                            this.wildfire.setAttacking(true);
                            if (!this.wildfire.func_174814_R()) {
                                this.wildfire.field_70170_p.func_184133_a(null, this.wildfire.func_180425_c(), (SoundEvent)ModSounds.WILDFIRE_SHOOT.get(), this.wildfire.func_184176_by(), 1.0f, 1.0f);
                            }
                            double fireballcount = ((Integer)OutvotedConfig.COMMON.fireballcount.get()).intValue();
                            double offsetangle = Math.toRadians((Double)OutvotedConfig.COMMON.offsetangle.get());
                            double maxdepressangle = Math.toRadians((Double)OutvotedConfig.COMMON.maxdepressangle.get());
                            d1 = livingentity.func_226277_ct_() - this.wildfire.func_226277_ct_();
                            d2 = livingentity.func_226283_e_(0.5) - this.wildfire.func_226283_e_(0.5);
                            d3 = livingentity.func_226281_cx_() - this.wildfire.func_226281_cx_();
                            int i = 0;
                            while ((double)i <= fireballcount - 1.0) {
                                double angle = ((double)i - (fireballcount - 1.0) / 2.0) * offsetangle;
                                double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                                double y = d2;
                                double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                                if (Math.abs(Math.atan2(d2, Math.sqrt(d1 * d1 + d3 * d3))) > maxdepressangle) {
                                    y = -Math.tan(maxdepressangle) * Math.sqrt(d1 * d1 + d3 * d3);
                                }
                                WildfireFireballEntity wildfirefireballentity = new WildfireFireballEntity(this.wildfire.field_70170_p, (LivingEntity)this.wildfire, x, y, z);
                                wildfirefireballentity.func_70107_b(wildfirefireballentity.func_226277_ct_(), this.wildfire.func_226283_e_(0.5), wildfirefireballentity.func_226281_cx_());
                                this.wildfire.field_70170_p.func_217376_c((Entity)wildfirefireballentity);
                                ++i;
                            }
                        }
                    } else if ((float)this.attackTime < 160.0f + health && (float)this.attackTime > 90.0f - health) {
                        this.wildfire.setShielding(true);
                    } else if (this.attackTime >= 30 && this.attackTime >= 50) {
                        this.wildfire.setShielding(false);
                        this.wildfire.shieldDisabled = false;
                    }
                    this.wildfire.func_184224_h(this.wildfire.getShielding());
                    this.wildfire.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.firedRecentlyTimer < 5) {
                    this.wildfire.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.wildfire.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }
    }
}

