/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.util;

import io.github.how_bout_no.outvoted.entity.WildfireEntity;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import io.github.how_bout_no.outvoted.init.ModItems;
import io.github.how_bout_no.outvoted.item.WildfireShieldItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEvents {
    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() != null) {
            Entity attacker = event.getSource().func_76346_g();
            LivingEntity player = event.getEntityLiving();
            Item shield = player.func_184607_cu().func_77973_b();
            if (shield instanceof WildfireShieldItem && player.func_184585_cz()) {
                if (event.getSource().func_76352_a()) {
                    event.getSource().func_76364_f().func_70015_d(5);
                } else {
                    attacker.func_70015_d(5);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        if (event.getEntity().func_200600_R() == ModEntityTypes.WILDFIRE.get()) {
            WildfireEntity entity = (WildfireEntity)event.getEntityLiving();
            ItemEntity helmet = event.getDrops().stream().filter(item -> item.func_92059_d().func_77973_b() == ModItems.WILDFIRE_HELMET.get()).findFirst().orElse(null);
            if (helmet != null && entity.getVariant() == 1) {
                helmet.func_92059_d().func_196082_o().func_74776_a("CustomModelData", 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void fixItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals("outvoted")) continue;
            if (entry.key.func_110623_a().equals("inferno_helmet")) {
                entry.remap(ModItems.WILDFIRE_HELMET.get());
            }
            if (entry.key.func_110623_a().equals("inferno_shield")) {
                entry.remap(ModItems.WILDFIRE_SHIELD.get());
            }
            if (entry.key.func_110623_a().equals("inferno_shield_part")) {
                entry.remap(ModItems.WILDFIRE_SHIELD_PART.get());
            }
            if (entry.key.func_110623_a().equals("inferno_piece")) {
                entry.remap(ModItems.WILDFIRE_PIECE.get());
            }
            if (!entry.key.func_110623_a().equals("inferno_spawn_egg")) continue;
            entry.remap(ModItems.WILDFIRE_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void fixEntityMappings(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals("outvoted") || !entry.key.func_110623_a().equals("inferno")) continue;
            entry.remap(ModEntityTypes.WILDFIRE.get());
        }
    }
}

