/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.world.gen;

import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.entity.HungerEntity;
import io.github.how_bout_no.outvoted.entity.KrakenEntity;
import io.github.how_bout_no.outvoted.entity.WildfireEntity;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="outvoted", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEntitySpawns {
    public static void spawnEntities() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            String biomename = biome.getRegistryName().toString();
            if (((Boolean)OutvotedConfig.COMMON.spawnwildfire.get()).booleanValue() && biome.func_201856_r() == Biome.Category.NETHER && (!((Boolean)OutvotedConfig.COMMON.restrictwildfire.get()).booleanValue() || biomename.equals("minecraft:nether"))) {
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)ModEntityTypes.WILDFIRE.get(), ((Integer)OutvotedConfig.COMMON.ratewildfire.get()).intValue(), 1, 1));
            }
            if (((Boolean)OutvotedConfig.COMMON.spawnhunger.get()).booleanValue() && (biome.func_201856_r() == Biome.Category.DESERT || biome.func_201856_r() == Biome.Category.SWAMP)) {
                biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)ModEntityTypes.HUNGER.get(), ((Integer)OutvotedConfig.COMMON.ratehunger.get()).intValue(), 1, 1));
            }
            if (!((Boolean)OutvotedConfig.COMMON.spawnkraken.get()).booleanValue() || biome.func_185355_j() != -1.8f || biomename.equals("minecraft:deep_frozen_ocean")) continue;
            biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)ModEntityTypes.KRAKEN.get(), ((Integer)OutvotedConfig.COMMON.ratekraken.get()).intValue(), 1, 1));
        }
    }

    @SubscribeEvent
    public static void checkMobs(LivingSpawnEvent.CheckSpawn event) {
        List entities;
        double area = 6.0;
        Entity e = event.getEntity();
        if ((((Boolean)OutvotedConfig.COMMON.spawnkraken.get()).booleanValue() || ((Boolean)OutvotedConfig.COMMON.spawnhunger.get()).booleanValue()) && (e instanceof KrakenEntity || e instanceof HungerEntity) && event.getSpawnReason() == SpawnReason.NATURAL && !(entities = event.getWorld().func_72839_b(event.getEntity(), event.getEntity().func_174813_aQ().func_72321_a(area, area, area).func_72321_a(-area, -area, -area))).isEmpty()) {
            event.setResult(Event.Result.DENY);
        }
        if (((Boolean)OutvotedConfig.COMMON.spawnwildfire.get()).booleanValue() && e instanceof WildfireEntity && event.getSpawnReason() == SpawnReason.NATURAL && event.getWorld().func_175659_aa() != Difficulty.HARD && (entities = event.getWorld().func_72839_b(event.getEntity(), event.getEntity().func_174813_aQ().func_72321_a(area, area, area).func_72321_a(-area, -area, -area))).stream().anyMatch(entity -> entity instanceof WildfireEntity)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void changeMobs(LivingSpawnEvent.SpecialSpawn event) {
        Entity e = event.getEntity();
        if (((Boolean)OutvotedConfig.COMMON.spawnwildfire.get()).booleanValue()) {
            World world;
            if (e instanceof WildfireEntity && event.getSpawnReason() == SpawnReason.NATURAL) {
                world = event.getEntity().func_130014_f_();
                int max = 3;
                switch (world.func_175659_aa()) {
                    case NORMAL: {
                        max = 4;
                        break;
                    }
                    case HARD: {
                        max = 5;
                    }
                }
                int min = max - 1;
                int rand = new Random().nextInt(max - min) + min;
                for (int i = 1; i <= rand; ++i) {
                    BlazeEntity blaze = (BlazeEntity)EntityType.field_200792_f.func_200721_a(world);
                    blaze.func_70080_a(e.func_226282_d_(2.0), e.func_226278_cu_(), e.func_226287_g_(2.0), e.field_70177_z, e.field_70125_A);
                    while (!world.func_175623_d(blaze.func_180425_c())) {
                        blaze.func_70080_a(e.func_226282_d_(2.0), e.func_226278_cu_(), e.func_226287_g_(2.0), e.field_70177_z, e.field_70125_A);
                    }
                    world.func_217376_c((Entity)blaze);
                }
            }
            if (e instanceof BlazeEntity && event.getSpawnReason() == SpawnReason.SPAWNER && Math.random() > 0.85) {
                world = event.getEntity().func_130014_f_();
                WildfireEntity wildfire = (WildfireEntity)((EntityType)ModEntityTypes.WILDFIRE.get()).func_200721_a(world);
                wildfire.func_70080_a(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), e.field_70177_z, e.field_70125_A);
                world.func_217376_c((Entity)wildfire);
                event.setCanceled(true);
            }
        }
    }
}

