/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.event;

import java.util.Arrays;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.util.ArtComparator;

@Mod.EventBusSubscriber(modid="paintings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PaintingInteractEvent {
    @SubscribeEvent
    public static void interact(PlayerInteractEvent.EntityInteractSpecific event) {
        if (ConfigData.cycle_paintings && event.getTarget() instanceof Painting && event.getHand().equals((Object)InteractionHand.MAIN_HAND) && event.getPlayer() != null && event.getPlayer().m_21205_().m_41720_().equals(Items.f_42487_)) {
            Painting painting = (Painting)event.getTarget();
            Motive original = painting.f_31902_;
            Motive firstMatch = null;
            Motive newArt = null;
            Motive[] validArtsArray = ForgeRegistries.PAINTING_TYPES.getValues().toArray(new Motive[0]);
            Arrays.sort(validArtsArray, new ArtComparator());
            boolean takeNext = false;
            for (Motive type : validArtsArray) {
                if (PaintingInteractEvent.equalSizes(original, type)) {
                    if (firstMatch == null) {
                        firstMatch = type;
                    }
                    if (takeNext) {
                        newArt = type;
                        break;
                    }
                    if (!PaintingInteractEvent.equalNames(original, type)) continue;
                    takeNext = true;
                    continue;
                }
                if (!takeNext) continue;
                newArt = firstMatch;
                break;
            }
            if (newArt == null && takeNext) {
                newArt = firstMatch;
            }
            Paintings.UTILITY.setArt(painting, newArt);
        }
    }

    private static boolean equalSizes(Motive a, Motive b) {
        return a.m_31896_() == b.m_31896_() && a.m_31901_() == b.m_31901_();
    }

    private static boolean equalNames(Motive a, Motive b) {
        return a.getRegistryName().equals((Object)b.getRegistryName());
    }
}

