/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.decoration.Motive;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.packet.server.SPacketPainting;

public class PaintingScreen
extends Screen {
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private Motive[] resLocs;
    private final int entityID;
    private int scrollbarscroll = 0;
    private final Button defaultButton = new Button(0, 0, 0, 0, (Component)new TextComponent("default"), Button2 -> {});

    public PaintingScreen(Motive[] resLocs, int entityID) {
        super((Component)new TranslatableComponent("select.a.painting"));
        this.resLocs = resLocs;
        this.entityID = entityID;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
        this.scrollbarscroll = 0;
    }

    private void addButtons() {
        int END_X = this.f_96543_ - 30;
        int prevHeight = this.resLocs[0].m_31901_();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (Motive type : this.resLocs) {
            if (posx + type.m_31896_() > END_X || prevHeight > type.m_31901_()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = type.m_31901_();
            }
            this.m_142416_((GuiEventListener)new PaintingButton(posx, posy, type.m_31896_(), type.m_31901_(), (Component)new TextComponent(""), Button2 -> {
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketPainting(type, this.entityID));
                this.m_7861_();
                this.m_7379_();
            }, type));
            posx += 5 + type.m_31896_();
            ++index;
        }
        this.centerRow(rowstart, this.f_169369_.size() - 1);
    }

    private void centerRow(int start, int end) {
        int left = this.getAbstractWidget((int)start).f_93620_;
        int right = this.getAbstractWidget((int)end).f_93620_ + this.getAbstractWidget(end).m_5711_();
        int correction = (this.f_96543_ - 20 - (right - left)) / 2;
        for (int i = start; i <= end; ++i) {
            AbstractWidget widget = this.getAbstractWidget(i);
            if (!(widget instanceof PaintingButton)) continue;
            ((PaintingButton)widget).shiftX(correction);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float p_render_3_) {
        this.m_7333_(stack);
        PaintingScreen.m_93172_((PoseStack)stack, (int)10, (int)30, (int)(this.f_96543_ - 10), (int)(this.f_96544_ - 30), (int)0x44444444);
        Window window = this.f_96541_.m_91268_();
        int scale = (int)window.m_85449_();
        RenderSystem.m_69488_((int)(10 * scale), (int)(30 * scale), (int)(this.f_96543_ * scale), (int)((this.f_96544_ - 60) * scale));
        super.m_6305_(stack, mouseX, mouseY, p_render_3_);
        RenderSystem.m_69471_();
        if (!this.f_169369_.isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        PaintingScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        this.drawToolTips(stack, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double mouseScroll) {
        AbstractWidget last = this.getAbstractWidget(this.f_169369_.size() - 1);
        AbstractWidget first = this.getAbstractWidget(0);
        int forsee_bottom_limit = (int)((double)(last.f_93621_ + last.m_93694_()) + mouseScroll * 16.0);
        int bottom_limit = this.f_96544_ - 30 - last.m_93694_();
        int forsee_top_limit = (int)((double)first.f_93621_ + mouseScroll * 16.0);
        int top_limit = 35;
        if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.m_6050_(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
            return super.m_6050_(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.m_6050_(mouseX, mouseY, mouseScroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        amountY *= -1.0;
        AbstractWidget last = this.getAbstractWidget(this.f_169369_.size() - 1);
        AbstractWidget first = this.getAbstractWidget(0);
        int forsee_bottom_limit = (int)((double)(last.f_93621_ + last.m_93694_()) + (amountY /= 2.0) * 16.0);
        int bottom_limit = this.f_96544_ - 30 - last.m_93694_();
        int forsee_top_limit = (int)((double)first.f_93621_ + amountY * 16.0);
        int top_limit = 35;
        if (amountY < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
        }
        if (amountY > 0.0 && forsee_top_limit > top_limit) {
            return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
        }
        this.move(amountY);
        return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget w : this.f_169369_) {
            this.getAbstractWidget((Widget)w).f_93621_ = (int)((double)this.getAbstractWidget((Widget)w).f_93621_ + scroll * 16.0);
        }
    }

    private void drawToolTips(PoseStack mat, int mouseX, int mouseY) {
        if (!ConfigData.show_painting_size) {
            return;
        }
        for (Widget guiButton : this.f_169369_) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).m_5953_(mouseX, mouseY)) continue;
            TextComponent text = new TextComponent(button.m_5711_() / 16 + "x" + button.m_93694_() / 16);
            HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)text);
            Style style = Style.f_131099_.m_131144_(hover);
            this.m_96570_(mat, style, this.f_96543_ / 2 - this.f_96547_.m_92895_(text.m_6111_()) - 4, this.f_96544_ - 7);
        }
    }

    private void drawFakeScrollBar(PoseStack mat) {
        int top = this.getAbstractWidget((int)0).f_93621_;
        float containerSize = this.f_96544_ - 60;
        int bot = this.getAbstractWidget((int)(this.f_169369_.size() - 1)).f_93621_ + this.getAbstractWidget(this.f_169369_.size() - 1).m_93694_();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
            this.m_93179_(mat, this.f_96543_ - 10, 30, this.f_96543_, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.m_93179_(mat, this.f_96543_ - 10, 30 + (int)relativeScroll, this.f_96543_, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }

    private AbstractWidget getAbstractWidget(Widget widget) {
        if (widget instanceof AbstractWidget) {
            return (AbstractWidget)widget;
        }
        return this.defaultButton;
    }

    private AbstractWidget getAbstractWidget(int index) {
        if (index < 0 || index > this.f_169369_.size()) {
            return this.defaultButton;
        }
        Widget w = (Widget)this.f_169369_.get(index);
        if (w instanceof AbstractWidget) {
            return (AbstractWidget)w;
        }
        return this.defaultButton;
    }
}

