/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import net.minecraft.world.entity.decoration.Motive;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.util.PaintingUtility;
import subaraki.paintings.util.json.PaintingPackReader;

@Mod(value="paintings")
@Mod.EventBusSubscriber(modid="paintings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paintings {
    public static final String MODID = "paintings";
    public static final Logger LOG = LogManager.getLogger((String)"paintings");
    public static final PaintingUtility UTILITY;

    public Paintings() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new NetworkHandler();
    }

    public void modConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    @SubscribeEvent
    public static void registerPaintings(RegistryEvent.Register<Motive> event) {
        PaintingPackReader.registerToMinecraft(event);
    }

    static {
        new PaintingPackReader().init();
        UTILITY = new PaintingUtility();
    }
}

