/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.packet.client;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.packet.IPacketBase;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.util.ClientReferences;

public class CPacketPainting
implements IPacketBase {
    private int entityID;
    private String[] resLocNames;

    public CPacketPainting() {
    }

    public CPacketPainting(Painting painting, ResourceLocation[] resLocs) {
        this.entityID = painting.m_142049_();
        this.resLocNames = new String[resLocs.length];
        int index = 0;
        for (ResourceLocation resLoc : resLocs) {
            this.resLocNames[index++] = resLoc.toString();
        }
    }

    public CPacketPainting(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.resLocNames.length);
        for (String path : this.resLocNames) {
            buf.m_130070_(path);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.resLocNames = new String[buf.readInt()];
        for (int i = 0; i < this.resLocNames.length; ++i) {
            this.resLocNames[i] = buf.m_130277_();
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.resLocNames.length == 1) {
                Entity entity = ClientReferences.getClientPlayer().f_19853_.m_6815_(this.entityID);
                if (entity instanceof Painting) {
                    Painting painting = (Painting)entity;
                    Motive type = (Motive)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(this.resLocNames[0]));
                    Paintings.UTILITY.setArt(painting, type);
                    Paintings.UTILITY.updatePaintingBoundingBox((HangingEntity)painting);
                }
            } else {
                Motive[] types = new Motive[this.resLocNames.length];
                int dex = 0;
                for (String path : this.resLocNames) {
                    types[dex++] = (Motive)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(path));
                }
                ClientReferences.openPaintingScreen(types, this.entityID);
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketPainting.class, CPacketPainting::encode, CPacketPainting::new, CPacketPainting::handle);
    }
}

