/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.containers;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tv.mongotheelder.pitg.recipes.GlassPaneTableRecipe;
import tv.mongotheelder.pitg.setup.Registration;

public class GlassPaneTableContainer
extends Container {
    private static final int INPUT_SLOT = 0;
    private static final int RESULT_SLOT = 1;
    private final IWorldPosCallable access;
    private final IntReferenceHolder selectedRecipeIndex = IntReferenceHolder.func_221492_a();
    private final World level;
    private List<GlassPaneTableRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.field_190927_a;
    final Slot inputSlot;
    final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    public final IInventory container = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            GlassPaneTableContainer.this.func_75130_a((IInventory)this);
            GlassPaneTableContainer.this.slotUpdateListener.run();
        }
    };
    private final CraftResultInventory resultContainer = new CraftResultInventory();

    public GlassPaneTableContainer(int p_i50059_1_, PlayerInventory p_i50059_2_) {
        this(p_i50059_1_, p_i50059_2_, IWorldPosCallable.field_221489_a);
    }

    public GlassPaneTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable dataAccess) {
        super((ContainerType)Registration.GLASS_PANE_TABLE_CONTAINER.get(), id);
        this.access = dataAccess;
        this.level = playerInventory.field_70458_d.field_70170_p;
        this.inputSlot = this.func_75146_a(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.func_75146_a(new Slot((IInventory)this.resultContainer, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
                GlassPaneTableContainer.this.resultContainer.func_201560_d(player);
                ItemStack itemstack = GlassPaneTableContainer.this.inputSlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    GlassPaneTableContainer.this.setupResultSlot();
                }
                return super.func_190901_a(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipeIndex);
    }

    public GlassPaneTableContainer(int i, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(i, playerInventory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<GlassPaneTableRecipe> getRecipes() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNumRecipes() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasInputItem() {
        return this.inputSlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity player) {
        return GlassPaneTableContainer.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)((Block)Registration.GLASS_PANE_TABLE.get()));
    }

    public boolean func_75140_a(PlayerEntity player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.func_221494_a(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack itemstack = this.inputSlot.func_75211_c();
        if (itemstack.func_77973_b() != this.input.func_77973_b()) {
            this.input = itemstack.func_77946_l();
            this.setupRecipeList(inventory, itemstack);
        }
    }

    private void setupRecipeList(IInventory inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.func_221494_a(-1);
        this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.level.func_199532_z().func_215370_b(Registration.GLASS_PANE_TABLE_TYPE, inventory, this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.func_221495_b())) {
            GlassPaneTableRecipe glassPaneTableRecipe = this.recipes.get(this.selectedRecipeIndex.func_221495_b());
            this.resultContainer.func_193056_a((IRecipe)glassPaneTableRecipe);
            this.resultSlot.func_75215_d(glassPaneTableRecipe.func_77572_b(this.container));
        } else {
            this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public ContainerType<?> func_216957_a() {
        return (ContainerType)Registration.GLASS_PANE_TABLE_CONTAINER.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.resultContainer && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (slotIndex == 1) {
                item.func_77622_d(itemstack1, player.field_70170_p, player);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (slotIndex == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.level.func_199532_z().func_215371_a(IRecipeType.field_222154_f, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (slotIndex > 1 && slotIndex < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : slotIndex >= 29 && slotIndex < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.resultContainer.func_70304_b(1);
        this.access.func_221486_a((p_217079_2_, p_217079_3_) -> this.func_193327_a(player, player.field_70170_p, this.container));
    }
}

