/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.mongotheelder.pitg.blocks.DualGlassPane;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.blocks.GlassPaneTable;
import tv.mongotheelder.pitg.blocks.HorizontalGlassPane;
import tv.mongotheelder.pitg.setup.Registration;

public class PitgBlockStateProvider
extends BlockStateProvider {
    public PitgBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "pitg", exFileHelper);
    }

    public BlockModelBuilder makeBlockModel(String modelName, String color, String parent, String textureName, boolean usesEdge) {
        String actualColor = color.isEmpty() ? "" : color + "_";
        String modelPath = "block/" + actualColor + modelName;
        String texturePath = "block/" + actualColor + textureName;
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(modelPath);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("pitg", "block/bases/" + parent + "_base")))).texture("pane", this.modLoc(texturePath))).texture("edge", this.modLoc(texturePath + (usesEdge ? "_top" : "")))).texture("particle", "#pane");
        return model;
    }

    public BlockModelBuilder makeGlassPaneTableModel(String modelName, String parent, String textureName, String paneName) {
        String modelPath = "block/" + modelName;
        String texturePath = "block/" + textureName;
        String panePath = "block/" + paneName;
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(modelPath);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("pitg", "block/bases/" + parent + "_base")))).texture("body", this.modLoc(texturePath))).texture("pane", this.modLoc(panePath))).texture("particle", "#body");
        return model;
    }

    public void blockstateGlassPane(GlassPane block, BlockModelBuilder side, BlockModelBuilder corner) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).condition((Property)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((Property)GlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((Property)GlassPane.EAST, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)GlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((Property)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((Property)GlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((Property)GlassPane.WEST, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)GlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corner).addModel()).condition((Property)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corner).rotationY(90).addModel()).condition((Property)GlassPane.EAST, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corner).rotationY(180).addModel()).condition((Property)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corner).rotationY(270).addModel()).condition((Property)GlassPane.WEST, (Comparable[])new Boolean[]{true}).condition((Property)GlassPane.NORTH, (Comparable[])new Boolean[]{true});
    }

    public void blockstateHorizontalGlassPane(HorizontalGlassPane block, BlockModelBuilder upper, BlockModelBuilder lower) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP).modelForState().modelFile((ModelFile)upper).addModel();
        builder.partialState().with((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.BOTTOM).modelForState().modelFile((ModelFile)lower).addModel();
    }

    public void blockstateGlassPaneTable(GlassPaneTable block, BlockModelBuilder model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void blockstateDualGlassPane(GlassPane block, BlockModelBuilder side, BlockModelBuilder left, BlockModelBuilder right, BlockModelBuilder corners) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).addModel()).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(180).addModel()).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(90).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(270).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).addModel()).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(180).addModel()).condition((Property)DualGlassPane.EAST, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(90).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(270).addModel()).condition((Property)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        builder.part().modelFile((ModelFile)corners).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(90).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(270).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(180).addModel();
    }

    private void buildGlassPaneModels(GlassPane block) {
        BlockModelBuilder singleModel = this.makeBlockModel("glasspane_single", "", "glasspane_side", "glass_pane", true);
        BlockModelBuilder cornerModel = this.makeBlockModel("glasspane_corner", "", "glasspane_corner", "glass_pane", true);
        this.blockstateGlassPane(block, singleModel, cornerModel);
    }

    private void buildStainedGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder singleModel = this.makeBlockModel("stained_glasspane_single", color, "glasspane_side", "stained_glass_pane", true);
        BlockModelBuilder cornerModel = this.makeBlockModel("stained_glasspane_corner", color, "glasspane_corner", "stained_glass_pane", true);
        this.blockstateGlassPane(block, singleModel, cornerModel);
    }

    private void buildTintedGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder singleModel = this.makeBlockModel("tinted_glasspane_single", color, "glasspane_side", "tinted_glass_pane", false);
        BlockModelBuilder cornerModel = this.makeBlockModel("tinted_glasspane_corner", color, "glasspane_corner", "tinted_glass_pane", false);
        this.blockstateGlassPane(block, singleModel, cornerModel);
    }

    private void buildPlainGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder singleModel = this.makeBlockModel("plain_glasspane_single", color, "glasspane_side", "plain_glass_pane", false);
        BlockModelBuilder cornerModel = this.makeBlockModel("plain_glasspane_corner", color, "glasspane_corner", "plain_glass_pane", false);
        this.blockstateGlassPane(block, singleModel, cornerModel);
    }

    private void buildHorizontalGlassPaneModels(HorizontalGlassPane block) {
        BlockModelBuilder lowerModel = this.makeBlockModel("horizontal_glasspane_lower", "", "horizontal_glasspane_lower", "glass_pane", true);
        BlockModelBuilder upperModel = this.makeBlockModel("horizontal_glasspane_upper", "", "horizontal_glasspane_upper", "glass_pane", true);
        this.blockstateHorizontalGlassPane(block, upperModel, lowerModel);
    }

    private void buildStainedHorizontalGlassPaneModels(HorizontalGlassPane block, String color) {
        BlockModelBuilder lowerModel = this.makeBlockModel("stained_horizontal_glasspane_lower", color, "horizontal_glasspane_lower", "stained_glass_pane", true);
        BlockModelBuilder upperModel = this.makeBlockModel("stained_horizontal_glasspane_upper", color, "horizontal_glasspane_upper", "stained_glass_pane", true);
        this.blockstateHorizontalGlassPane(block, upperModel, lowerModel);
    }

    private void buildTintedHorizontalGlassPaneModels(HorizontalGlassPane block, String color) {
        BlockModelBuilder lowerModel = this.makeBlockModel("tinted_horizontal_glasspane_lower", color, "horizontal_glasspane_lower", "tinted_glass_pane", false);
        BlockModelBuilder upperModel = this.makeBlockModel("tinted_horizontal_glasspane_upper", color, "horizontal_glasspane_upper", "tinted_glass_pane", false);
        this.blockstateHorizontalGlassPane(block, upperModel, lowerModel);
    }

    private void buildPlainHorizontalGlassPaneModels(HorizontalGlassPane block, String color) {
        BlockModelBuilder lowerModel = this.makeBlockModel("plain_horizontal_glasspane_lower", color, "horizontal_glasspane_lower", "plain_glass_pane", false);
        BlockModelBuilder upperModel = this.makeBlockModel("plain_horizontal_glasspane_upper", color, "horizontal_glasspane_upper", "plain_glass_pane", false);
        this.blockstateHorizontalGlassPane(block, upperModel, lowerModel);
    }

    private void buildDualGlassPaneModels(GlassPane block) {
        BlockModelBuilder sideModel = this.makeBlockModel("dualglasspane_side", "", "dualglasspane_side", "glass_pane", true);
        BlockModelBuilder leftModel = this.makeBlockModel("dualglasspane_left_edge", "", "dualglasspane_left_edge", "glass_pane", true);
        BlockModelBuilder rightModel = this.makeBlockModel("dualglasspane_right_edge", "", "dualglasspane_right_edge", "glass_pane", true);
        BlockModelBuilder cornerModel = this.makeBlockModel("dualglasspane_corner", "", "dualglasspane_corner", "glass_pane", true);
        this.blockstateDualGlassPane(block, sideModel, leftModel, rightModel, cornerModel);
    }

    private void buildStainedDualGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder sideModel = this.makeBlockModel("stained_dualglasspane_side", color, "dualglasspane_side", "stained_glass_pane", true);
        BlockModelBuilder leftModel = this.makeBlockModel("stained_dualglasspane_left_edge", color, "dualglasspane_left_edge", "stained_glass_pane", true);
        BlockModelBuilder rightModel = this.makeBlockModel("stained_dualglasspane_right_edge", color, "dualglasspane_right_edge", "stained_glass_pane", true);
        BlockModelBuilder cornerModel = this.makeBlockModel("stained_dualglasspane_corner", color, "dualglasspane_corner", "stained_glass_pane", true);
        this.blockstateDualGlassPane(block, sideModel, leftModel, rightModel, cornerModel);
    }

    private void buildTintedDualGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder sideModel = this.makeBlockModel("tinted_dualglasspane_side", color, "dualglasspane_side", "tinted_glass_pane", false);
        BlockModelBuilder leftModel = this.makeBlockModel("tinted_dualglasspane_left_edge", color, "dualglasspane_left_edge", "tinted_glass_pane", false);
        BlockModelBuilder rightModel = this.makeBlockModel("tinted_dualglasspane_right_edge", color, "dualglasspane_right_edge", "tinted_glass_pane", false);
        BlockModelBuilder cornerModel = this.makeBlockModel("tinted_dualglasspane_corner", color, "dualglasspane_corner", "tinted_glass_pane", false);
        this.blockstateDualGlassPane(block, sideModel, leftModel, rightModel, cornerModel);
    }

    private void buildPlainDualGlassPaneModels(GlassPane block, String color) {
        BlockModelBuilder sideModel = this.makeBlockModel("plain_dualglasspane_side", color, "dualglasspane_side", "plain_glass_pane", false);
        BlockModelBuilder leftModel = this.makeBlockModel("plain_dualglasspane_left_edge", color, "dualglasspane_left_edge", "plain_glass_pane", false);
        BlockModelBuilder rightModel = this.makeBlockModel("plain_dualglasspane_right_edge", color, "dualglasspane_right_edge", "plain_glass_pane", false);
        BlockModelBuilder cornerModel = this.makeBlockModel("plain_dualglasspane_corner", color, "dualglasspane_corner", "plain_glass_pane", false);
        this.blockstateDualGlassPane(block, sideModel, leftModel, rightModel, cornerModel);
    }

    private void buildGlassPaneTableModels(GlassPaneTable block) {
        BlockModelBuilder model = this.makeGlassPaneTableModel("glass_pane_table", "glass_pane_table", "glass_pane_table_body", "purple_stained_glass_pane");
        this.blockstateGlassPaneTable(block, model);
    }

    protected void registerStatesAndModels() {
        this.buildGlassPaneModels((GlassPane)Registration.GLASS_PANE.get());
        this.buildHorizontalGlassPaneModels((HorizontalGlassPane)Registration.HORIZONTAL_GLASS_PANE.get());
        this.buildDualGlassPaneModels((GlassPane)Registration.DUAL_GLASS_PANE.get());
        this.buildGlassPaneTableModels((GlassPaneTable)Registration.GLASS_PANE_TABLE.get());
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.func_176610_l().toLowerCase();
            this.buildStainedHorizontalGlassPaneModels((HorizontalGlassPane)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), colorName);
            this.buildTintedHorizontalGlassPaneModels((HorizontalGlassPane)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), colorName);
            this.buildPlainHorizontalGlassPaneModels((HorizontalGlassPane)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), colorName);
            this.buildStainedGlassPaneModels((GlassPane)Registration.STAINED_GLASS_PANES.get(color).get(), colorName);
            this.buildTintedGlassPaneModels((GlassPane)Registration.TINTED_GLASS_PANES.get(color).get(), colorName);
            this.buildPlainGlassPaneModels((GlassPane)Registration.PLAIN_GLASS_PANES.get(color).get(), colorName);
            this.buildStainedDualGlassPaneModels((GlassPane)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), colorName);
            this.buildTintedDualGlassPaneModels((GlassPane)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), colorName);
            this.buildPlainDualGlassPaneModels((GlassPane)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), colorName);
        }
    }
}

