/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.mongotheelder.pitg.setup.Registration;

public class PitgItemProvider
extends ItemModelProvider {
    public PitgItemProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "pitg", existingFileHelper);
    }

    public void itemModel(String itemPath, String texturePath, String itemGlyph) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, "item/handheld")).texture("layer0", this.modLoc(texturePath))).texture("layer1", this.modLoc("item/" + itemGlyph))).transforms().transform(ModelBuilder.Perspective.GUI).scale(0.8f, 0.8f, 0.8f);
    }

    public void makeSingleItemModel(String color, Item item, String colorSpace, String itemGlyph) {
        String actualColorName = color.equals("") ? "" : color + colorSpace;
        String texturePath = "block/" + actualColorName + "glass_pane";
        String itemPath = "item/" + item.func_199767_j().getRegistryName().func_110623_a();
        this.itemModel(itemPath, texturePath, itemGlyph);
    }

    public void makeDualItemModel(String color, Item item, String colorSpace, String itemGlyph) {
        String actualColorName = color.equals("") ? "" : color + colorSpace;
        String texturePath = "block/" + actualColorName + "glass_pane";
        String itemPath = "item/" + item.func_199767_j().getRegistryName().func_110623_a();
        this.itemModel(itemPath, texturePath, itemGlyph);
    }

    public void makeHorizontalItemModel(String color, Item item, String colorSpace, String itemGlyph) {
        String actualColorName = color.equals("") ? "" : color + colorSpace;
        String texturePath = "block/" + actualColorName + "glass_pane";
        String itemPath = "item/" + item.func_199767_j().getRegistryName().func_110623_a();
        this.itemModel(itemPath, texturePath, itemGlyph);
    }

    protected void registerModels() {
        this.makeSingleItemModel("", (Item)Registration.GLASS_PANE_ITEM.get(), "", "s");
        this.makeDualItemModel("", (Item)Registration.DUAL_GLASS_PANE_ITEM.get(), "", "d");
        this.makeHorizontalItemModel("", (Item)Registration.HORIZONTAL_GLASS_PANE_ITEM.get(), "", "h");
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.func_176610_l().toLowerCase();
            this.makeSingleItemModel(colorName, (Item)Registration.STAINED_GLASS_PANE_ITEMS.get(color).get(), "_stained_", "s");
            this.makeSingleItemModel(colorName, (Item)Registration.TINTED_GLASS_PANE_ITEMS.get(color).get(), "_tinted_", "st");
            this.makeSingleItemModel(colorName, (Item)Registration.PLAIN_GLASS_PANE_ITEMS.get(color).get(), "_plain_", "sp");
            this.makeDualItemModel(colorName, (Item)Registration.STAINED_DUAL_GLASS_PANE_ITEMS.get(color).get(), "_stained_", "d");
            this.makeDualItemModel(colorName, (Item)Registration.TINTED_DUAL_GLASS_PANE_ITEMS.get(color).get(), "_tinted_", "dt");
            this.makeDualItemModel(colorName, (Item)Registration.PLAIN_DUAL_GLASS_PANE_ITEMS.get(color).get(), "_plain_", "dp");
            this.makeHorizontalItemModel(colorName, (Item)Registration.STAINED_HORIZONTAL_GLASS_PANE_ITEMS.get(color).get(), "_stained_", "h");
            this.makeHorizontalItemModel(colorName, (Item)Registration.TINTED_HORIZONTAL_GLASS_PANE_ITEMS.get(color).get(), "_tinted_", "ht");
            this.makeHorizontalItemModel(colorName, (Item)Registration.PLAIN_HORIZONTAL_GLASS_PANE_ITEMS.get(color).get(), "_plain_", "hp");
        }
    }
}

