/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import tv.mongotheelder.pitg.setup.Registration;

public class PitgRecipeProvider
extends RecipeProvider {
    private static final ITag<Item> ALL_GLASS_PANE_TAG = ItemTags.func_199901_a((String)"pitg:all_glass_panes");
    private static final ITag<Item> DUAL_GLASS_PANE_TAG = ItemTags.func_199901_a((String)"pitg:dual_glass_panes");
    private static final ITag<Item> GLASS_PANE_TAG = Tags.Items.GLASS_PANES;

    public PitgRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void glassPaneRecipe(Consumer<IFinishedRecipe> consumer, String recipeName, Block result, Block ingredient, String group, int requires, int gives) {
        ResourceLocation loc = result.getRegistryName();
        consumer.accept(new GlassPaneResult(new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + recipeName), result.func_199767_j(), gives, group, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), requires));
    }

    protected void glassPaneRecipe(Consumer<IFinishedRecipe> consumer, Block result, Block ingredient, String group, int requires, int gives) {
        consumer.accept(new GlassPaneResult(result.getRegistryName(), result.func_199767_j(), gives, group, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), requires));
    }

    private void glassPaneTableBuilder(Consumer<IFinishedRecipe> consumer, ResourceLocation recipeName, Ingredient result, IItemProvider ingredient, int quantity) {
        consumer.accept(new GlassPaneTableResult(recipeName, "glass_pane", result, ingredient.func_199767_j(), quantity));
    }

    private void glassPanesInBlastFurnace(Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(ALL_GLASS_PANE_TAG), (IItemProvider)Items.field_221792_df, (float)0.0f, (int)100).func_218628_a("has_glass_pane", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150410_aZ})).func_218635_a(consumer, PitgRecipeProvider.mcLoc("glass_panes_in_blast_furnace"));
    }

    private void dualGlassPanesInBlastFurnace(Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(DUAL_GLASS_PANE_TAG), (IItemProvider)((IItemProvider)Registration.DUAL_GLASS_PANE.get()), (float)0.0f, (int)100).func_218628_a("has_glass_pane", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150410_aZ})).func_218635_a(consumer, PitgRecipeProvider.mcLoc("dual_glass_panes_in_blast_furnace"));
    }

    private void glassInBlastFurnace(Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a((ITag)Tags.Items.GLASS), (IItemProvider)Blocks.field_150359_w, (float)0.0f, (int)100).func_218628_a("has_glass_pane", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150410_aZ})).func_218635_a(consumer, PitgRecipeProvider.mcLoc("glass_in_blast_furnace"));
    }

    private void glazingToolRecipe(Consumer<IFinishedRecipe> consumer, String group) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)Registration.GLAZING_TOOL_ITEM.get()), (int)1).func_203221_a((ITag)Tags.Items.RODS_WOODEN).func_203221_a((ITag)Tags.Items.INGOTS_IRON).func_203221_a((ITag)Tags.Items.GLASS_PANES).func_200483_a("has_glass_pane", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150410_aZ})).func_200490_a(group).func_200482_a(consumer);
    }

    private void glassPaneTableRecipe(Consumer<IFinishedRecipe> consumer, String group) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registration.GLASS_PANE_TABLE.get()), (int)1).func_200472_a("SGS").func_200472_a(" S ").func_200472_a("SSS").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_234778_rB_.getItem()).func_200469_a(Character.valueOf('G'), GLASS_PANE_TAG).func_200465_a("has_glass_pane", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150410_aZ})).func_200473_b(group).func_200464_a(consumer);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.glassPaneRecipe(consumer, (Block)Registration.GLASS_PANE.get(), Blocks.field_150410_aZ, "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, (Block)Registration.HORIZONTAL_GLASS_PANE.get(), (Block)Registration.GLASS_PANE.get(), "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, "_from_horizontal_glass_pane", Blocks.field_150410_aZ, (Block)Registration.HORIZONTAL_GLASS_PANE.get(), "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, (Block)Registration.DUAL_GLASS_PANE.get(), (Block)Registration.GLASS_PANE.get(), "glass_pane", 2, 1);
        this.glassPaneRecipe(consumer, "_from_vanilla_glass_pane", (Block)Registration.DUAL_GLASS_PANE.get(), Blocks.field_150410_aZ, "glass_pane", 2, 1);
        this.glassPaneRecipe(consumer, "_from_dual_glass_pane", (Block)Registration.GLASS_PANE.get(), (Block)Registration.DUAL_GLASS_PANE.get(), "glass_pane", 1, 2);
        this.createTableRecipes(consumer);
        this.glazingToolRecipe(consumer, "tools");
        this.glassPaneTableRecipe(consumer, "tools");
        this.glassPanesInBlastFurnace(consumer);
        this.dualGlassPanesInBlastFurnace(consumer);
        this.glassInBlastFurnace(consumer);
        for (DyeColor color : DyeColor.values()) {
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_GLASS_PANES.get(color).get(), PitgRecipeProvider.lookupVanillaPaneBlock(color), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.PLAIN_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, "_from_horizontal_glass_pane", PitgRecipeProvider.lookupVanillaPaneBlock(color), (Block)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), PitgRecipeProvider.lookupVanillaPaneBlock(color), color + "_dual_stained_glass_pane", 2, 1);
            this.glassPaneRecipe(consumer, "_from_stained_glass_panes", (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 2, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, "_from_dual_glass_pane", PitgRecipeProvider.lookupVanillaPaneBlock(color), (Block)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 2);
            this.createColoredTableRecipes(consumer, color);
        }
    }

    public static Block lookupVanillaPaneBlock(DyeColor color) {
        switch (color) {
            case RED: {
                return Blocks.field_196775_gN;
            }
            default: {
                return Blocks.field_196825_gz;
            }
            case BLACK: {
                return Blocks.field_196776_gO;
            }
            case BLUE: {
                return Blocks.field_196771_gK;
            }
            case CYAN: {
                return Blocks.field_196768_gI;
            }
            case GRAY: {
                return Blocks.field_196765_gG;
            }
            case LIME: {
                return Blocks.field_196763_gE;
            }
            case PINK: {
                return Blocks.field_196764_gF;
            }
            case BROWN: {
                return Blocks.field_196773_gL;
            }
            case GREEN: {
                return Blocks.field_196774_gM;
            }
            case ORANGE: {
                return Blocks.field_196758_gA;
            }
            case PURPLE: {
                return Blocks.field_196769_gJ;
            }
            case YELLOW: {
                return Blocks.field_196761_gD;
            }
            case MAGENTA: {
                return Blocks.field_196759_gB;
            }
            case LIGHT_BLUE: {
                return Blocks.field_196760_gC;
            }
            case LIGHT_GRAY: 
        }
        return Blocks.field_196767_gH;
    }

    public void createColoredTableRecipes(Consumer<IFinishedRecipe> consumer, DyeColor color) {
        ITag.INamedTag panes = ItemTags.func_199901_a((String)("pitg:" + color + "_glass_panes"));
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.mcLoc(color + "_stained_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)PitgRecipeProvider.lookupVanillaPaneBlock(color), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.STAINED_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.PLAIN_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.TINTED_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_horizontal_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_horizontal_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_horizontal_glass_pains_from_table"), Ingredient.func_199805_a((ITag)panes), (IItemProvider)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        ITag.INamedTag duelPanes = ItemTags.func_199901_a((String)("pitg:" + color + "_dual_glass_panes"));
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_dual_glass_pains_from_table"), Ingredient.func_199805_a((ITag)duelPanes), (IItemProvider)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_dual_glass_pains_from_table"), Ingredient.func_199805_a((ITag)duelPanes), (IItemProvider)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_dual_glass_pains_from_table"), Ingredient.func_199805_a((ITag)duelPanes), (IItemProvider)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), 1);
    }

    public void createTableRecipes(Consumer<IFinishedRecipe> consumer) {
        ITag.INamedTag inputs = ItemTags.func_199901_a((String)"pitg:glass_panes");
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.mcLoc("glass_pain_from_table"), Ingredient.func_199805_a((ITag)inputs), (IItemProvider)Blocks.field_150410_aZ, 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc("glass_pain_from_table"), Ingredient.func_199805_a((ITag)inputs), (IItemProvider)Registration.GLASS_PANE.get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc("horizontal_glass_pain_from_table"), Ingredient.func_199805_a((ITag)inputs), (IItemProvider)Registration.HORIZONTAL_GLASS_PANE.get(), 1);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("pitg", path);
    }

    private static ResourceLocation mcLoc(String path) {
        return new ResourceLocation(path);
    }

    public static class GlassPaneResult
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final Ingredient ingredient;
        private final int requires;

        public GlassPaneResult(ResourceLocation recipeName, Item p_i48268_2_, int p_i48268_3_, String p_i48268_4_, Ingredient p_i48268_5_, int requires) {
            this.id = recipeName;
            this.result = p_i48268_2_;
            this.count = p_i48268_3_;
            this.group = p_i48268_4_;
            this.ingredient = p_i48268_5_;
            this.requires = requires;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (int i = 0; i < this.requires; ++i) {
                jsonarray.add(this.ingredient.func_200304_c());
            }
            p_218610_1_.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            p_218610_1_.add("result", (JsonElement)jsonobject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }

    private static class GlassPaneTableResult
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private final IRecipeSerializer<?> type;

        public GlassPaneTableResult(ResourceLocation recipeName, String group, Ingredient ingredient, Item result, int count) {
            this.id = recipeName;
            this.type = (IRecipeSerializer)Registration.GLASS_PANE_TABLE_RECIPE_SERIALIZER.get();
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.count = count;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            p_218610_1_.add("ingredient", this.ingredient.func_200304_c());
            p_218610_1_.addProperty("result", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            p_218610_1_.addProperty("count", (Number)this.count);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.type;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

