/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.Config;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.blocks.HorizontalGlassPane;
import tv.mongotheelder.pitg.items.GlazingToolMode;

public class GlazingTool
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();

    public GlazingTool(Item.Properties properties) {
        super(properties);
    }

    public static GlazingToolMode getMode(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof GlazingTool) {
            return GlazingTool.readMode(itemStack);
        }
        return GlazingToolMode.ROTATE;
    }

    public void writeMode(ItemStack itemStack, GlazingToolMode mode) {
        if (itemStack.func_77973_b() instanceof GlazingTool) {
            CompoundNBT tag = itemStack.func_196082_o();
            tag.func_74778_a("glazing_tool_tag", mode.func_176610_l().toLowerCase());
        }
    }

    public static GlazingToolMode readMode(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !(stack.func_77973_b() instanceof GlazingTool)) {
            return GlazingToolMode.ROTATE;
        }
        return GlazingToolMode.byName(tag.func_74779_i("glazing_tool_tag").toLowerCase());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() || ((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("Mode: " + GlazingTool.readMode(stack).func_176610_l()).func_240699_a_(TextFormatting.DARK_GREEN));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return (Boolean)Config.ENABLE_PANE_BREAK.get() != false && GlazingTool.readMode(stack) == GlazingToolMode.BREAK || stack.func_77948_v();
    }

    private Half flip(BlockState state) {
        return state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP ? Half.BOTTOM : Half.TOP;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            PlayerEntity player = context.func_195999_j();
            BlockPos blockpos = context.func_195995_a();
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            GlazingToolMode mode = GlazingTool.readMode(context.func_195996_i());
            if (block instanceof GlassPane || block instanceof HorizontalGlassPane) {
                if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() && mode == GlazingToolMode.BREAK) {
                    if (player != null && player.func_213453_ef()) {
                        world.func_217377_a(blockpos, false);
                        Block.func_180635_a((World)world, (BlockPos)blockpos, (ItemStack)block.getPickBlock(blockstate, null, (IBlockReader)world, blockpos, player));
                    }
                } else if (((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue() && mode == GlazingToolMode.UNBREAKABLE) {
                    world.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((Property)GlassPane.UNBREAKABLE, (Comparable)Boolean.valueOf((Boolean)blockstate.func_177229_b((Property)GlassPane.UNBREAKABLE) == false)));
                } else if (block instanceof GlassPane) {
                    world.func_175656_a(blockpos, block.rotate(blockstate, (IWorld)world, blockpos, player != null && player.func_213453_ef() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90));
                } else if (block instanceof HorizontalGlassPane) {
                    world.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)this.flip(blockstate)));
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.func_201670_d()) {
            ItemStack toolItem = playerIn.func_184586_b(handIn);
            this.writeMode(toolItem, GlazingTool.readMode(toolItem).advanceMode());
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }
}

