/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.setup;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tv.mongotheelder.pitg.blocks.DualGlassPane;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.blocks.GlassPaneTable;
import tv.mongotheelder.pitg.blocks.HorizontalGlassPane;
import tv.mongotheelder.pitg.blocks.StainedDualGlassPane;
import tv.mongotheelder.pitg.blocks.StainedGlassPane;
import tv.mongotheelder.pitg.blocks.StainedHorizontalGlassPane;
import tv.mongotheelder.pitg.containers.GlassPaneTableContainer;
import tv.mongotheelder.pitg.items.GlazingTool;
import tv.mongotheelder.pitg.recipes.GlassPaneTableRecipe;
import tv.mongotheelder.pitg.recipes.GlassPaneTableRecipeSerializer;
import tv.mongotheelder.pitg.setup.ModSetup;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pitg");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pitg");
    private static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"pitg");
    private static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"pitg");
    private static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"pitg");
    public static Map<DyeColor, RegistryObject<StainedGlassPane>> STAINED_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> STAINED_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedDualGlassPane>> STAINED_DUAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedDualGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> STAINED_DUAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedHorizontalGlassPane>> STAINED_HORIZONTAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedHorizontalGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> STAINED_HORIZONTAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedHorizontalGlassPane>> TINTED_HORIZONTAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedHorizontalGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> TINTED_HORIZONTAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedGlassPane>> TINTED_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> TINTED_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedDualGlassPane>> TINTED_DUAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedDualGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> TINTED_DUAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedHorizontalGlassPane>> PLAIN_HORIZONTAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedHorizontalGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> PLAIN_HORIZONTAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedGlassPane>> PLAIN_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> PLAIN_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static Map<DyeColor, RegistryObject<StainedDualGlassPane>> PLAIN_DUAL_GLASS_PANES = new HashMap<DyeColor, RegistryObject<StainedDualGlassPane>>();
    public static Map<DyeColor, RegistryObject<Item>> PLAIN_DUAL_GLASS_PANE_ITEMS = new HashMap<DyeColor, RegistryObject<Item>>();
    public static final RegistryObject<GlassPane> GLASS_PANE = BLOCKS.register("glasspane", () -> new GlassPane(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_()));
    public static final RegistryObject<Item> GLASS_PANE_ITEM = ITEMS.register("glasspane", () -> new BlockItem((Block)GLASS_PANE.get(), new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP)));
    public static final RegistryObject<DualGlassPane> DUAL_GLASS_PANE = BLOCKS.register("dualglasspane", () -> new DualGlassPane(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_()));
    public static final RegistryObject<Item> DUAL_GLASS_PANE_ITEM = ITEMS.register("dualglasspane", () -> new BlockItem((Block)DUAL_GLASS_PANE.get(), new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP)));
    public static final RegistryObject<HorizontalGlassPane> HORIZONTAL_GLASS_PANE = BLOCKS.register("horizontal_glasspane", () -> new HorizontalGlassPane(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_()));
    public static final RegistryObject<Item> HORIZONTAL_GLASS_PANE_ITEM = ITEMS.register("horizontal_glasspane", () -> new BlockItem((Block)HORIZONTAL_GLASS_PANE.get(), new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP)));
    public static final RegistryObject<GlassPaneTable> GLASS_PANE_TABLE = BLOCKS.register("glass_pane_table", () -> new GlassPaneTable(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.3f).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<Item> GLASS_PANE_TABLE_ITEM = ITEMS.register("glass_pane_table", () -> new BlockItem((Block)GLASS_PANE_TABLE.get(), new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP)));
    public static final RegistryObject<ContainerType<GlassPaneTableContainer>> GLASS_PANE_TABLE_CONTAINER = CONTAINERS.register("glass_pane_table", () -> IForgeContainerType.create(GlassPaneTableContainer::new));
    public static final IRecipeType<GlassPaneTableRecipe> GLASS_PANE_TABLE_TYPE = IRecipeType.func_222147_a((String)"pitg:glass_pane_table");
    public static final RegistryObject<IRecipeSerializer<?>> GLASS_PANE_TABLE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("glass_pane_table", () -> new GlassPaneTableRecipeSerializer<GlassPaneTableRecipe>(GlassPaneTableRecipe::new));
    public static final RegistryObject<Item> GLAZING_TOOL_ITEM = ITEMS.register("glazing_tool", () -> new GlazingTool(new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP).func_200917_a(1)));
    public static final RegistryObject<Item> GREEN_DYE_ITEM = ITEMS.register("green_dye", () -> new DyeItem(DyeColor.GREEN, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP)));

    public static void init() {
        Registration.registerGlassPanes();
        Registration.registerDualGlassPanes();
        Registration.registerHorizontalPanes();
        Registration.registerTintedPanes();
        Registration.registerTintedDualGlassPanes();
        Registration.registerTintedHorizontalPanes();
        Registration.registerPlainPanes();
        Registration.registerPlainDualGlassPanes();
        Registration.registerPlainHorizontalPanes();
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void registerGlassPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_stained_glasspane";
            StainedGlassPane pane = new StainedGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            STAINED_GLASS_PANES.put(color, (RegistryObject<StainedGlassPane>)BLOCKS.register(name, () -> pane));
            STAINED_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerTintedPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_tinted_glasspane";
            StainedGlassPane pane = new StainedGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            TINTED_GLASS_PANES.put(color, (RegistryObject<StainedGlassPane>)BLOCKS.register(name, () -> pane));
            TINTED_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerPlainPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_plain_glasspane";
            StainedGlassPane pane = new StainedGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            PLAIN_GLASS_PANES.put(color, (RegistryObject<StainedGlassPane>)BLOCKS.register(name, () -> pane));
            PLAIN_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerDualGlassPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_stained_dualglasspane";
            StainedDualGlassPane pane = new StainedDualGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            STAINED_DUAL_GLASS_PANES.put(color, (RegistryObject<StainedDualGlassPane>)BLOCKS.register(name, () -> pane));
            STAINED_DUAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerTintedDualGlassPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_tinted_dualglasspane";
            StainedDualGlassPane pane = new StainedDualGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            TINTED_DUAL_GLASS_PANES.put(color, (RegistryObject<StainedDualGlassPane>)BLOCKS.register(name, () -> pane));
            TINTED_DUAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerPlainDualGlassPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_plain_dualglasspane";
            StainedDualGlassPane pane = new StainedDualGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            PLAIN_DUAL_GLASS_PANES.put(color, (RegistryObject<StainedDualGlassPane>)BLOCKS.register(name, () -> pane));
            PLAIN_DUAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerHorizontalPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_stained_horizontal_glasspane";
            StainedHorizontalGlassPane pane = new StainedHorizontalGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            STAINED_HORIZONTAL_GLASS_PANES.put(color, (RegistryObject<StainedHorizontalGlassPane>)BLOCKS.register(name, () -> pane));
            STAINED_HORIZONTAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerTintedHorizontalPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_tinted_horizontal_glasspane";
            StainedHorizontalGlassPane pane = new StainedHorizontalGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            TINTED_HORIZONTAL_GLASS_PANES.put(color, (RegistryObject<StainedHorizontalGlassPane>)BLOCKS.register(name, () -> pane));
            TINTED_HORIZONTAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }

    private static void registerPlainHorizontalPanes() {
        for (DyeColor color : DyeColor.values()) {
            String name = color.func_176610_l().toLowerCase() + "_plain_horizontal_glasspane";
            StainedHorizontalGlassPane pane = new StainedHorizontalGlassPane(color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
            PLAIN_HORIZONTAL_GLASS_PANES.put(color, (RegistryObject<StainedHorizontalGlassPane>)BLOCKS.register(name, () -> pane));
            PLAIN_HORIZONTAL_GLASS_PANE_ITEMS.put(color, (RegistryObject<Item>)ITEMS.register(name, () -> new BlockItem((Block)pane, new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP))));
        }
    }
}

