/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.blocks;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.Config;

public class GlassPane
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");
    public static final BooleanProperty UNBREAKABLE = BooleanProperty.m_61465_((String)"unbreakable");
    public static final int NORTH_MASK = 1;
    public static final int WEST_MASK = 2;
    public static final int SOUTH_MASK = 4;
    public static final int EAST_MASK = 8;
    protected final VoxelShape[] shapes;
    protected final VoxelShape[] collisionShapes;
    protected final Object2IntMap<BlockState> indexHash = new Object2IntOpenHashMap();
    protected static final double PANE_WIDTH = 16.0;
    protected static final double PANE_THICKNESS = 2.0;
    protected static final double PANE_HEIGHT = 16.0;
    protected static final double CORNER_HITBOX_SIZE = 0.25;
    protected static final Logger LOGGER = LogManager.getLogger();

    public GlassPane(BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(16.0, 2.0, 16.0);
        this.collisionShapes = this.makeShapes(16.0, 2.0, 16.0);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.FALSE)).m_61124_((Property)EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)SOUTH, (Comparable)Boolean.FALSE)).m_61124_((Property)WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)UNBREAKABLE, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected VoxelShape[] makeShapes(double paneWidth, double paneThickness, double paneHeight) {
        VoxelShape south = Block.m_49796_((double)0.0, (double)0.0, (double)(paneWidth - paneThickness), (double)paneWidth, (double)paneHeight, (double)paneWidth);
        VoxelShape west = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)paneThickness, (double)paneHeight, (double)paneWidth);
        VoxelShape north = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)paneWidth, (double)paneHeight, (double)paneThickness);
        VoxelShape east = Block.m_49796_((double)(paneWidth - paneThickness), (double)0.0, (double)0.0, (double)paneWidth, (double)paneHeight, (double)paneWidth);
        VoxelShape empty = Shapes.m_83144_();
        VoxelShape[] shapes = new VoxelShape[]{empty, north, west, Shapes.m_83110_((VoxelShape)north, (VoxelShape)west), south, empty, Shapes.m_83110_((VoxelShape)south, (VoxelShape)west), empty, east, Shapes.m_83110_((VoxelShape)north, (VoxelShape)east), empty, empty, Shapes.m_83110_((VoxelShape)south, (VoxelShape)east), empty, empty, empty};
        return shapes;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return (Boolean)Config.ENABLE_UNBREAKABLE.get() != false && (Boolean)state.m_61143_((Property)UNBREAKABLE) != false ? -1.0f : 0.3f;
    }

    protected int getIndex(BlockState state) {
        return this.indexHash.computeIntIfAbsent((Object)state, blockState -> {
            int i = 0;
            if (((Boolean)blockState.m_61143_((Property)NORTH)).booleanValue()) {
                i |= 1;
            }
            if (((Boolean)blockState.m_61143_((Property)EAST)).booleanValue()) {
                i |= 8;
            }
            if (((Boolean)blockState.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= 4;
            }
            if (((Boolean)blockState.m_61143_((Property)WEST)).booleanValue()) {
                i |= 2;
            }
            return i;
        });
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(((Boolean)state.m_61143_((Property)WEST) != false || (Boolean)state.m_61143_((Property)NORTH) != false) && (Boolean)state.m_61143_((Property)EAST) == false && (Boolean)state.m_61143_((Property)SOUTH) == false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(((Boolean)state.m_61143_((Property)EAST) != false || (Boolean)state.m_61143_((Property)NORTH) != false) && (Boolean)state.m_61143_((Property)WEST) == false && (Boolean)state.m_61143_((Property)SOUTH) == false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(((Boolean)state.m_61143_((Property)EAST) != false || (Boolean)state.m_61143_((Property)SOUTH) != false) && (Boolean)state.m_61143_((Property)WEST) == false && (Boolean)state.m_61143_((Property)NORTH) == false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(((Boolean)state.m_61143_((Property)WEST) != false || (Boolean)state.m_61143_((Property)SOUTH) != false) && (Boolean)state.m_61143_((Property)EAST) == false && (Boolean)state.m_61143_((Property)NORTH) == false));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean horizontalFaceClicked;
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        boolean clickedSouth = context.m_43720_().f_82481_ - (double)blockpos.m_123343_() >= 0.75 && direction != Direction.NORTH;
        boolean clickedNorth = context.m_43720_().f_82481_ - (double)blockpos.m_123343_() <= 0.25 && direction != Direction.SOUTH;
        boolean clickedEast = context.m_43720_().f_82479_ - (double)blockpos.m_123341_() >= 0.75 && direction != Direction.WEST;
        boolean clickedWest = context.m_43720_().f_82479_ - (double)blockpos.m_123341_() <= 0.25 && direction != Direction.EAST;
        boolean bl = horizontalFaceClicked = !clickedNorth && !clickedEast && !clickedSouth && !clickedWest;
        if (horizontalFaceClicked) {
            Direction[] lookingDirections = context.m_6232_();
            Direction lookingDirection = lookingDirections[0].m_122434_().m_122479_() ? lookingDirections[0] : lookingDirections[1];
            switch (lookingDirection) {
                case NORTH: {
                    clickedNorth = true;
                    break;
                }
                case WEST: {
                    clickedWest = true;
                    break;
                }
                case SOUTH: {
                    clickedSouth = true;
                    break;
                }
                case EAST: {
                    clickedEast = true;
                    break;
                }
                default: {
                    LOGGER.info("Center click was not able to determine facing direction");
                    clickedNorth = true;
                }
            }
        }
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(clickedNorth))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(clickedWest))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(clickedSouth))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(clickedEast))).m_61124_((Property)UNBREAKABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, UNBREAKABLE, WATERLOGGED});
    }
}

