/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.containers;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tv.mongotheelder.pitg.recipes.GlassPaneTableRecipe;
import tv.mongotheelder.pitg.setup.Registration;

public class GlassPaneTableContainer
extends AbstractContainerMenu {
    private static final int INPUT_SLOT = 0;
    private static final int RESULT_SLOT = 1;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<GlassPaneTableRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    final Slot inputSlot;
    final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            GlassPaneTableContainer.this.m_6199_((Container)this);
            GlassPaneTableContainer.this.slotUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();

    public GlassPaneTableContainer(int p_i50059_1_, Inventory p_i50059_2_) {
        this(p_i50059_1_, p_i50059_2_, ContainerLevelAccess.f_39287_);
    }

    public GlassPaneTableContainer(int id, Inventory playerInventory, ContainerLevelAccess dataAccess) {
        super((MenuType)Registration.GLASS_PANE_TABLE_CONTAINER.get(), id);
        this.access = dataAccess;
        this.level = playerInventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.f_19853_, player, stack.m_41613_());
                GlassPaneTableContainer.this.resultContainer.m_8015_(player);
                ItemStack itemstack = GlassPaneTableContainer.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    GlassPaneTableContainer.this.setupResultSlot();
                    super.m_142406_(player, stack);
                }
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public GlassPaneTableContainer(int i, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(i, playerInventory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<GlassPaneTableRecipe> getRecipes() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNumRecipes() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return GlassPaneTableContainer.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)Registration.GLASS_PANE_TABLE.get()));
    }

    public boolean m_6366_(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    public void m_6199_(Container inventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (itemstack.m_41720_() != this.input.m_41720_()) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(inventory, itemstack);
        }
    }

    private void setupRecipeList(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_(Registration.GLASS_PANE_TABLE_TYPE, inventory, this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            GlassPaneTableRecipe glassPaneTableRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            this.resultContainer.m_6029_((Recipe)glassPaneTableRecipe);
            this.resultSlot.m_5852_(glassPaneTableRecipe.m_5874_(this.container));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)Registration.GLASS_PANE_TABLE_CONTAINER.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex == 1) {
                item.m_7836_(itemstack1, player.f_19853_, player);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (slotIndex > 1 && slotIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : slotIndex >= 29 && slotIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_217079_2_, p_217079_3_) -> this.m_150411_(player, this.container));
    }
}

