/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import tv.mongotheelder.pitg.setup.Registration;

public class PitgRecipeProvider
extends RecipeProvider {
    private static final Tag<Item> ALL_GLASS_PANE_TAG = ItemTags.m_13194_((String)"pitg:all_glass_panes");
    private static final Tag<Item> DUAL_GLASS_PANE_TAG = ItemTags.m_13194_((String)"pitg:dual_glass_panes");
    private static final Tag<Item> GLASS_PANE_TAG = Tags.Items.GLASS_PANES;

    public PitgRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void glassPaneRecipe(Consumer<FinishedRecipe> consumer, String recipeName, Block result, Block ingredient, String group, int requires, int gives) {
        ResourceLocation loc = result.getRegistryName();
        consumer.accept(new GlassPaneResult(new ResourceLocation(loc.m_135827_(), loc.m_135815_() + recipeName), result.m_5456_(), gives, group, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), requires));
    }

    protected void glassPaneRecipe(Consumer<FinishedRecipe> consumer, Block result, Block ingredient, String group, int requires, int gives) {
        consumer.accept(new GlassPaneResult(result.getRegistryName(), result.m_5456_(), gives, group, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), requires));
    }

    private void glassPaneTableBuilder(Consumer<FinishedRecipe> consumer, ResourceLocation recipeName, Ingredient result, ItemLike ingredient, int quantity) {
        consumer.accept(new GlassPaneTableResult(recipeName, "glass_pane", result, ingredient.m_5456_(), quantity));
    }

    private void glassPanesInBlastFurnace(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43911_(ALL_GLASS_PANE_TAG), (ItemLike)Items.f_42027_, (float)0.0f, (int)100).m_142284_("has_glass_pane", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50185_})).m_142700_(consumer, PitgRecipeProvider.mcLoc("glass_panes_in_blast_furnace"));
    }

    private void dualGlassPanesInBlastFurnace(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43911_(DUAL_GLASS_PANE_TAG), (ItemLike)((ItemLike)Registration.DUAL_GLASS_PANE.get()), (float)0.0f, (int)100).m_142284_("has_glass_pane", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50185_})).m_142700_(consumer, PitgRecipeProvider.mcLoc("dual_glass_panes_in_blast_furnace"));
    }

    private void glassInBlastFurnace(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43911_((Tag)Tags.Items.GLASS), (ItemLike)Blocks.f_50058_, (float)0.0f, (int)100).m_142284_("has_glass_pane", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50185_})).m_142700_(consumer, PitgRecipeProvider.mcLoc("glass_in_blast_furnace"));
    }

    private void glazingToolRecipe(Consumer<FinishedRecipe> consumer, String group) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)Registration.GLAZING_TOOL_ITEM.get()), (int)1).m_126182_((Tag)Tags.Items.RODS_WOODEN).m_126182_((Tag)Tags.Items.INGOTS_IRON).m_126182_((Tag)Tags.Items.GLASS_PANES).m_142284_("has_glass_pane", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50185_})).m_142409_(group).m_176498_(consumer);
    }

    private void glassPaneTableRecipe(Consumer<FinishedRecipe> consumer, String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)Registration.GLASS_PANE_TABLE.get()), (int)1).m_126130_("SGS").m_126130_(" S ").m_126130_("SSS").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42756_).m_126121_(Character.valueOf('G'), GLASS_PANE_TAG).m_142284_("has_glass_pane", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50185_})).m_142409_(group).m_176498_(consumer);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.glassPaneRecipe(consumer, (Block)Registration.GLASS_PANE.get(), Blocks.f_50185_, "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, (Block)Registration.HORIZONTAL_GLASS_PANE.get(), (Block)Registration.GLASS_PANE.get(), "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, "_from_horizontal_glass_pane", Blocks.f_50185_, (Block)Registration.HORIZONTAL_GLASS_PANE.get(), "glass_pane", 1, 1);
        this.glassPaneRecipe(consumer, (Block)Registration.DUAL_GLASS_PANE.get(), (Block)Registration.GLASS_PANE.get(), "glass_pane", 2, 1);
        this.glassPaneRecipe(consumer, "_from_vanilla_glass_pane", (Block)Registration.DUAL_GLASS_PANE.get(), Blocks.f_50185_, "glass_pane", 2, 1);
        this.glassPaneRecipe(consumer, "_from_dual_glass_pane", (Block)Registration.GLASS_PANE.get(), (Block)Registration.DUAL_GLASS_PANE.get(), "glass_pane", 1, 2);
        this.createTableRecipes(consumer);
        this.glazingToolRecipe(consumer, "tools");
        this.glassPaneTableRecipe(consumer, "tools");
        this.glassPanesInBlastFurnace(consumer);
        this.dualGlassPanesInBlastFurnace(consumer);
        this.glassInBlastFurnace(consumer);
        for (DyeColor color : DyeColor.values()) {
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_GLASS_PANES.get(color).get(), PitgRecipeProvider.lookupVanillaPaneBlock(color), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), (Block)Registration.PLAIN_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, "_from_horizontal_glass_pane", PitgRecipeProvider.lookupVanillaPaneBlock(color), (Block)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), color + "_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), PitgRecipeProvider.lookupVanillaPaneBlock(color), color + "_dual_stained_glass_pane", 2, 1);
            this.glassPaneRecipe(consumer, "_from_stained_glass_panes", (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 2, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, (Block)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), (Block)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 1);
            this.glassPaneRecipe(consumer, "_from_dual_glass_pane", PitgRecipeProvider.lookupVanillaPaneBlock(color), (Block)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), color + "_dual_stained_glass_pane", 1, 2);
            this.createColoredTableRecipes(consumer, color);
        }
    }

    public static Block lookupVanillaPaneBlock(DyeColor color) {
        switch (color) {
            case RED: {
                return Blocks.f_50370_;
            }
            default: {
                return Blocks.f_50303_;
            }
            case BLACK: {
                return Blocks.f_50371_;
            }
            case BLUE: {
                return Blocks.f_50367_;
            }
            case CYAN: {
                return Blocks.f_50365_;
            }
            case GRAY: {
                return Blocks.f_50363_;
            }
            case LIME: {
                return Blocks.f_50361_;
            }
            case PINK: {
                return Blocks.f_50362_;
            }
            case BROWN: {
                return Blocks.f_50368_;
            }
            case GREEN: {
                return Blocks.f_50369_;
            }
            case ORANGE: {
                return Blocks.f_50304_;
            }
            case PURPLE: {
                return Blocks.f_50366_;
            }
            case YELLOW: {
                return Blocks.f_50307_;
            }
            case MAGENTA: {
                return Blocks.f_50305_;
            }
            case LIGHT_BLUE: {
                return Blocks.f_50306_;
            }
            case LIGHT_GRAY: 
        }
        return Blocks.f_50364_;
    }

    public void createColoredTableRecipes(Consumer<FinishedRecipe> consumer, DyeColor color) {
        Tag.Named panes = ItemTags.m_13194_((String)("pitg:" + color + "_glass_panes"));
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.mcLoc(color + "_stained_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)PitgRecipeProvider.lookupVanillaPaneBlock(color), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.STAINED_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.PLAIN_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.TINTED_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_horizontal_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.STAINED_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_horizontal_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.PLAIN_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_horizontal_glass_pains_from_table"), Ingredient.m_43911_((Tag)panes), (ItemLike)Registration.TINTED_HORIZONTAL_GLASS_PANES.get(color).get(), 1);
        Tag.Named duelPanes = ItemTags.m_13194_((String)("pitg:" + color + "_dual_glass_panes"));
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_stained_dual_glass_pains_from_table"), Ingredient.m_43911_((Tag)duelPanes), (ItemLike)Registration.STAINED_DUAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_plain_dual_glass_pains_from_table"), Ingredient.m_43911_((Tag)duelPanes), (ItemLike)Registration.PLAIN_DUAL_GLASS_PANES.get(color).get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc(color + "_tinted_dual_glass_pains_from_table"), Ingredient.m_43911_((Tag)duelPanes), (ItemLike)Registration.TINTED_DUAL_GLASS_PANES.get(color).get(), 1);
    }

    public void createTableRecipes(Consumer<FinishedRecipe> consumer) {
        Tag.Named inputs = ItemTags.m_13194_((String)"pitg:glass_panes");
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.mcLoc("glass_pain_from_table"), Ingredient.m_43911_((Tag)inputs), (ItemLike)Blocks.f_50185_, 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc("glass_pain_from_table"), Ingredient.m_43911_((Tag)inputs), (ItemLike)Registration.GLASS_PANE.get(), 1);
        this.glassPaneTableBuilder(consumer, PitgRecipeProvider.modLoc("horizontal_glass_pain_from_table"), Ingredient.m_43911_((Tag)inputs), (ItemLike)Registration.HORIZONTAL_GLASS_PANE.get(), 1);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("pitg", path);
    }

    private static ResourceLocation mcLoc(String path) {
        return new ResourceLocation(path);
    }

    public static class GlassPaneResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final Ingredient ingredient;
        private final int requires;

        public GlassPaneResult(ResourceLocation recipeName, Item p_i48268_2_, int p_i48268_3_, String p_i48268_4_, Ingredient p_i48268_5_, int requires) {
            this.id = recipeName;
            this.result = p_i48268_2_;
            this.count = p_i48268_3_;
            this.group = p_i48268_4_;
            this.ingredient = p_i48268_5_;
            this.requires = requires;
        }

        public void m_7917_(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (int i = 0; i < this.requires; ++i) {
                jsonarray.add(this.ingredient.m_43942_());
            }
            p_218610_1_.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            p_218610_1_.add("result", (JsonElement)jsonobject);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    private static class GlassPaneTableResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private final RecipeSerializer<?> type;

        public GlassPaneTableResult(ResourceLocation recipeName, String group, Ingredient ingredient, Item result, int count) {
            this.id = recipeName;
            this.type = (RecipeSerializer)Registration.GLASS_PANE_TABLE_RECIPE_SERIALIZER.get();
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.count = count;
        }

        public void m_7917_(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            p_218610_1_.add("ingredient", this.ingredient.m_43942_());
            p_218610_1_.addProperty("result", Registry.f_122827_.m_7981_((Object)this.result).toString());
            p_218610_1_.addProperty("count", (Number)this.count);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

