/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.Config;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.blocks.HorizontalGlassPane;
import tv.mongotheelder.pitg.items.GlazingToolMode;

public class GlazingTool
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();

    public GlazingTool(Item.Properties properties) {
        super(properties);
    }

    public static GlazingToolMode getMode(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof GlazingTool) {
            return GlazingTool.readMode(itemStack);
        }
        return GlazingToolMode.ROTATE;
    }

    public void writeMode(ItemStack itemStack, GlazingToolMode mode) {
        if (itemStack.m_41720_() instanceof GlazingTool) {
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128359_("glazing_tool_tag", mode.m_7912_().toLowerCase());
        }
    }

    public static GlazingToolMode readMode(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !(stack.m_41720_() instanceof GlazingTool)) {
            return GlazingToolMode.ROTATE;
        }
        return GlazingToolMode.byName(tag.m_128461_("glazing_tool_tag").toLowerCase());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() || ((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("Mode: " + GlazingTool.readMode(stack).m_7912_()).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return (Boolean)Config.ENABLE_PANE_BREAK.get() != false && GlazingTool.readMode(stack) == GlazingToolMode.BREAK || stack.m_41793_();
    }

    private Half flip(BlockState state) {
        return state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP ? Half.BOTTOM : Half.TOP;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            Player player = context.m_43723_();
            BlockPos blockpos = context.m_8083_();
            BlockState blockstate = world.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            GlazingToolMode mode = GlazingTool.readMode(context.m_43722_());
            if (block instanceof GlassPane || block instanceof HorizontalGlassPane) {
                if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() && mode == GlazingToolMode.BREAK) {
                    if (player != null && player.m_6047_()) {
                        world.m_7471_(blockpos, false);
                        Block.m_49840_((Level)world, (BlockPos)blockpos, (ItemStack)block.getPickBlock(blockstate, null, (BlockGetter)world, blockpos, player));
                    }
                } else if (((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue() && mode == GlazingToolMode.UNBREAKABLE) {
                    world.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)GlassPane.UNBREAKABLE, (Comparable)Boolean.valueOf((Boolean)blockstate.m_61143_((Property)GlassPane.UNBREAKABLE) == false)));
                } else if (block instanceof GlassPane) {
                    world.m_46597_(blockpos, block.rotate(blockstate, (LevelAccessor)world, blockpos, player != null && player.m_6047_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90));
                } else if (block instanceof HorizontalGlassPane) {
                    world.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)this.flip(blockstate)));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.m_5776_()) {
            ItemStack toolItem = playerIn.m_21120_(handIn);
            this.writeMode(toolItem, GlazingTool.readMode(toolItem).advanceMode());
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }
}

