/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.blocks;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.setup.Config;

public class GlassPane
extends Block
implements IWaterLoggable {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty WATERLOGGED = BooleanProperty.func_177716_a((String)"waterlogged");
    public static final BooleanProperty UNBREAKABLE = BooleanProperty.func_177716_a((String)"unbreakable");
    public static final int NORTH_MASK = 1;
    public static final int WEST_MASK = 2;
    public static final int SOUTH_MASK = 4;
    public static final int EAST_MASK = 8;
    protected final VoxelShape[] shapes;
    protected final VoxelShape[] collisionShapes;
    protected final Object2IntMap<BlockState> indexHash = new Object2IntOpenHashMap();
    protected static final double PANE_WIDTH = 16.0;
    protected static final double PANE_THICKNESS = 2.0;
    protected static final double PANE_HEIGHT = 16.0;
    protected static final double CORNER_HITBOX_SIZE = 0.25;
    protected static final Logger LOGGER = LogManager.getLogger();

    public GlassPane(Block.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(16.0, 2.0, 16.0);
        this.collisionShapes = this.makeShapes(16.0, 2.0, 16.0);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)EAST, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)WEST, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)UNBREAKABLE, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected VoxelShape[] makeShapes(double paneWidth, double paneThickness, double paneHeight) {
        VoxelShape south = Block.func_208617_a((double)0.0, (double)0.0, (double)(paneWidth - paneThickness), (double)paneWidth, (double)paneHeight, (double)paneWidth);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)paneThickness, (double)paneHeight, (double)paneWidth);
        VoxelShape north = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)paneWidth, (double)paneHeight, (double)paneThickness);
        VoxelShape east = Block.func_208617_a((double)(paneWidth - paneThickness), (double)0.0, (double)0.0, (double)paneWidth, (double)paneHeight, (double)paneWidth);
        VoxelShape empty = VoxelShapes.func_197880_a();
        VoxelShape[] shapes = new VoxelShape[]{empty, north, west, VoxelShapes.func_197872_a((VoxelShape)north, (VoxelShape)west), south, empty, VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)west), empty, east, VoxelShapes.func_197872_a((VoxelShape)north, (VoxelShape)east), empty, empty, VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)east), empty, empty, empty};
        return shapes;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)Config.ENABLE_UNBREAKABLE.get() != false && (Boolean)blockState.func_177229_b((IProperty)UNBREAKABLE) != false ? -1.0f : 0.3f;
    }

    protected int getIndex(BlockState state) {
        return this.indexHash.computeIntIfAbsent((Object)state, blockState -> {
            int i = 0;
            if (((Boolean)blockState.func_177229_b((IProperty)NORTH)).booleanValue()) {
                i |= 1;
            }
            if (((Boolean)blockState.func_177229_b((IProperty)EAST)).booleanValue()) {
                i |= 8;
            }
            if (((Boolean)blockState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                i |= 4;
            }
            if (((Boolean)blockState.func_177229_b((IProperty)WEST)).booleanValue()) {
                i |= 2;
            }
            return i;
        });
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(((Boolean)state.func_177229_b((IProperty)WEST) != false || (Boolean)state.func_177229_b((IProperty)NORTH) != false) && (Boolean)state.func_177229_b((IProperty)EAST) == false && (Boolean)state.func_177229_b((IProperty)SOUTH) == false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(((Boolean)state.func_177229_b((IProperty)EAST) != false || (Boolean)state.func_177229_b((IProperty)NORTH) != false) && (Boolean)state.func_177229_b((IProperty)WEST) == false && (Boolean)state.func_177229_b((IProperty)SOUTH) == false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(((Boolean)state.func_177229_b((IProperty)EAST) != false || (Boolean)state.func_177229_b((IProperty)SOUTH) != false) && (Boolean)state.func_177229_b((IProperty)WEST) == false && (Boolean)state.func_177229_b((IProperty)NORTH) == false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(((Boolean)state.func_177229_b((IProperty)WEST) != false || (Boolean)state.func_177229_b((IProperty)SOUTH) != false) && (Boolean)state.func_177229_b((IProperty)EAST) == false && (Boolean)state.func_177229_b((IProperty)NORTH) == false));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean horizontalFaceClicked;
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        boolean clickedSouth = context.func_221532_j().field_72449_c - (double)blockpos.func_177952_p() >= 0.75 && direction != Direction.NORTH;
        boolean clickedNorth = context.func_221532_j().field_72449_c - (double)blockpos.func_177952_p() <= 0.25 && direction != Direction.SOUTH;
        boolean clickedEast = context.func_221532_j().field_72450_a - (double)blockpos.func_177958_n() >= 0.75 && direction != Direction.WEST;
        boolean clickedWest = context.func_221532_j().field_72450_a - (double)blockpos.func_177958_n() <= 0.25 && direction != Direction.EAST;
        boolean bl = horizontalFaceClicked = !clickedNorth && !clickedEast && !clickedSouth && !clickedWest;
        if (horizontalFaceClicked) {
            Direction[] lookingDirections = context.func_196009_e();
            Direction lookingDirection = lookingDirections[0].func_176740_k().func_176722_c() ? lookingDirections[0] : lookingDirections[1];
            switch (lookingDirection) {
                case NORTH: {
                    clickedNorth = true;
                    break;
                }
                case WEST: {
                    clickedWest = true;
                    break;
                }
                case SOUTH: {
                    clickedSouth = true;
                    break;
                }
                case EAST: {
                    clickedEast = true;
                    break;
                }
                default: {
                    LOGGER.info("Center click was not able to determine facing direction");
                    clickedNorth = true;
                }
            }
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(clickedNorth))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(clickedWest))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(clickedSouth))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(clickedEast))).func_206870_a((IProperty)UNBREAKABLE, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, WEST, SOUTH, UNBREAKABLE, WATERLOGGED});
    }
}

