/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import tv.mongotheelder.pitg.blocks.DualGlassPane;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.setup.Registration;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "pitg", exFileHelper);
    }

    public void modelGlassPaneSide(BlockModelBuilder model, String path) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 2.0f).face(Direction.NORTH).texture("#pane").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.SOUTH).texture("#pane").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().end()).element().from(2.0f, 0.0f, 0.0f).to(14.0f, 16.0f, 2.0f).face(Direction.UP).texture("#edge").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).uvs(7.0f, 2.0f, 9.0f, 14.0f).end().face(Direction.DOWN).texture("#edge").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).uvs(7.0f, 2.0f, 9.0f, 14.0f).end().end()).texture("pane", new ResourceLocation("minecraft", path + "glass"))).texture("edge", new ResourceLocation("minecraft", path + "glass_pane_top"))).texture("particle", "#pane");
    }

    public void modelGlassPaneLeftEdge(BlockModelBuilder model, String path) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 0.0f).to(2.0f, 16.0f, 2.0f).face(Direction.WEST).texture("#edge").uvs(7.0f, 0.0f, 9.0f, 16.0f).cullface(Direction.EAST).end().end()).texture("pane", new ResourceLocation("minecraft", path + "glass"))).texture("edge", new ResourceLocation("minecraft", path + "glass_pane_top"))).texture("particle", "#pane");
    }

    public void modelGlassPaneRightEdge(BlockModelBuilder model, String path) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(14.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 2.0f).face(Direction.EAST).texture("#edge").uvs(7.0f, 0.0f, 9.0f, 16.0f).cullface(Direction.WEST).end().end()).texture("pane", new ResourceLocation("minecraft", path + "glass"))).texture("edge", new ResourceLocation("minecraft", path + "glass_pane_top"))).texture("particle", "#pane");
    }

    public void modelGlassPaneCorners(BlockModelBuilder model, String path) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 0.0f).to(2.0f, 16.0f, 2.0f).face(Direction.DOWN).texture("#edge").uvs(7.0f, 0.0f, 9.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.UP).texture("#edge").uvs(7.0f, 0.0f, 9.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().end()).texture("pane", new ResourceLocation("minecraft", path + "glass"))).texture("edge", new ResourceLocation("minecraft", path + "glass_pane_top"))).texture("particle", "#pane");
    }

    public void blockstateGlassPane(GlassPane block, BlockModelBuilder side, BlockModelBuilder left, BlockModelBuilder right, BlockModelBuilder corners) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).addModel()).condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).addModel()).condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(180).addModel()).condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(180).addModel()).condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(90).addModel()).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(90).addModel()).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(270).addModel()).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(270).addModel()).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corners).addModel()).useOr().condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corners).rotationY(90).addModel()).useOr().condition((IProperty)GlassPane.NORTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corners).rotationY(270).addModel()).useOr().condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)corners).rotationY(180).addModel()).useOr().condition((IProperty)GlassPane.SOUTH, (Comparable[])new Boolean[]{true}).condition((IProperty)GlassPane.EAST, (Comparable[])new Boolean[]{true});
    }

    public void blockstateDualGlassPane(GlassPane block, BlockModelBuilder side, BlockModelBuilder left, BlockModelBuilder right, BlockModelBuilder corners) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).useOr().condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{true}).useOr().condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).useOr().condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{true}).useOr().condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).useOr().condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{true}).useOr().condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).useOr().condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{true}).useOr().condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).addModel()).condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(180).addModel()).condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(90).addModel()).condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)left).rotationY(270).addModel()).condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).addModel()).condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(180).addModel()).condition((IProperty)DualGlassPane.EAST, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.WEST, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(90).addModel()).condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)right).rotationY(270).addModel()).condition((IProperty)DualGlassPane.NORTH, (Comparable[])new Boolean[]{false}).condition((IProperty)DualGlassPane.SOUTH, (Comparable[])new Boolean[]{false});
        builder.part().modelFile((ModelFile)corners).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(90).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(270).addModel();
        builder.part().modelFile((ModelFile)corners).rotationY(180).addModel();
    }

    private void buildGlassPaneModels(GlassPane block, String color) {
        String path = "block/" + (color.equals("") ? "" : color + "_stained_");
        BlockModelBuilder side_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane");
        BlockModelBuilder left_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_edge_left");
        BlockModelBuilder right_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_edge_right");
        BlockModelBuilder corner_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_corners");
        this.modelGlassPaneSide(side_model, path);
        this.modelGlassPaneCorners(corner_model, path);
        this.modelGlassPaneLeftEdge(left_model, path);
        this.modelGlassPaneRightEdge(right_model, path);
        this.blockstateGlassPane(block, side_model, left_model, right_model, corner_model);
    }

    private void buildDualGlassPaneModels(GlassPane block, String color) {
        String path = "block/" + (color.equals("") ? "" : color + "_stained_");
        BlockModelBuilder side_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane");
        BlockModelBuilder left_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_edge_left");
        BlockModelBuilder right_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_edge_right");
        BlockModelBuilder corner_model = (BlockModelBuilder)this.models().getBuilder(path + "glasspane_corners");
        this.blockstateDualGlassPane(block, side_model, left_model, right_model, corner_model);
    }

    protected void registerStatesAndModels() {
        this.buildGlassPaneModels((GlassPane)Registration.GLASS_PANE.get(), "");
        this.buildGlassPaneModels((GlassPane)Registration.RED_STAINED_GLASS_PANE.get(), "red");
        this.buildGlassPaneModels((GlassPane)Registration.WHITE_STAINED_GLASS_PANE.get(), "white");
        this.buildGlassPaneModels((GlassPane)Registration.BLUE_STAINED_GLASS_PANE.get(), "blue");
        this.buildGlassPaneModels((GlassPane)Registration.ORANGE_STAINED_GLASS_PANE.get(), "orange");
        this.buildGlassPaneModels((GlassPane)Registration.MAGENTA_STAINED_GLASS_PANE.get(), "magenta");
        this.buildGlassPaneModels((GlassPane)Registration.LIGHT_BLUE_STAINED_GLASS_PANE.get(), "light_blue");
        this.buildGlassPaneModels((GlassPane)Registration.YELLOW_STAINED_GLASS_PANE.get(), "yellow");
        this.buildGlassPaneModels((GlassPane)Registration.LIME_STAINED_GLASS_PANE.get(), "lime");
        this.buildGlassPaneModels((GlassPane)Registration.PINK_STAINED_GLASS_PANE.get(), "pink");
        this.buildGlassPaneModels((GlassPane)Registration.GRAY_STAINED_GLASS_PANE.get(), "gray");
        this.buildGlassPaneModels((GlassPane)Registration.LIGHT_GRAY_STAINED_GLASS_PANE.get(), "light_gray");
        this.buildGlassPaneModels((GlassPane)Registration.CYAN_STAINED_GLASS_PANE.get(), "cyan");
        this.buildGlassPaneModels((GlassPane)Registration.PURPLE_STAINED_GLASS_PANE.get(), "purple");
        this.buildGlassPaneModels((GlassPane)Registration.BROWN_STAINED_GLASS_PANE.get(), "brown");
        this.buildGlassPaneModels((GlassPane)Registration.GREEN_STAINED_GLASS_PANE.get(), "green");
        this.buildGlassPaneModels((GlassPane)Registration.BLACK_STAINED_GLASS_PANE.get(), "black");
        this.buildDualGlassPaneModels((GlassPane)Registration.DUAL_GLASS_PANE.get(), "");
        this.buildDualGlassPaneModels((GlassPane)Registration.RED_STAINED_DUAL_GLASS_PANE.get(), "red");
        this.buildDualGlassPaneModels((GlassPane)Registration.WHITE_STAINED_DUAL_GLASS_PANE.get(), "white");
        this.buildDualGlassPaneModels((GlassPane)Registration.BLUE_STAINED_DUAL_GLASS_PANE.get(), "blue");
        this.buildDualGlassPaneModels((GlassPane)Registration.ORANGE_STAINED_DUAL_GLASS_PANE.get(), "orange");
        this.buildDualGlassPaneModels((GlassPane)Registration.MAGENTA_STAINED_DUAL_GLASS_PANE.get(), "magenta");
        this.buildDualGlassPaneModels((GlassPane)Registration.LIGHT_BLUE_STAINED_DUAL_GLASS_PANE.get(), "light_blue");
        this.buildDualGlassPaneModels((GlassPane)Registration.YELLOW_STAINED_DUAL_GLASS_PANE.get(), "yellow");
        this.buildDualGlassPaneModels((GlassPane)Registration.LIME_STAINED_DUAL_GLASS_PANE.get(), "lime");
        this.buildDualGlassPaneModels((GlassPane)Registration.PINK_STAINED_DUAL_GLASS_PANE.get(), "pink");
        this.buildDualGlassPaneModels((GlassPane)Registration.GRAY_STAINED_DUAL_GLASS_PANE.get(), "gray");
        this.buildDualGlassPaneModels((GlassPane)Registration.LIGHT_GRAY_STAINED_DUAL_GLASS_PANE.get(), "light_gray");
        this.buildDualGlassPaneModels((GlassPane)Registration.CYAN_STAINED_DUAL_GLASS_PANE.get(), "cyan");
        this.buildDualGlassPaneModels((GlassPane)Registration.PURPLE_STAINED_DUAL_GLASS_PANE.get(), "purple");
        this.buildDualGlassPaneModels((GlassPane)Registration.BROWN_STAINED_DUAL_GLASS_PANE.get(), "brown");
        this.buildDualGlassPaneModels((GlassPane)Registration.GREEN_STAINED_DUAL_GLASS_PANE.get(), "green");
        this.buildDualGlassPaneModels((GlassPane)Registration.BLACK_STAINED_DUAL_GLASS_PANE.get(), "black");
    }
}

