/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.blocks.GlassPane;
import tv.mongotheelder.pitg.items.GlazingToolMode;
import tv.mongotheelder.pitg.networking.ModePacket;
import tv.mongotheelder.pitg.networking.PacketHandler;
import tv.mongotheelder.pitg.setup.Config;

public class GlazingTool
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();

    public GlazingTool(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("pitg:unbreaking"), (itemStack, world, livingEntity) -> {
            if (livingEntity != null) {
                boolean flag;
                boolean bl = flag = livingEntity.func_184614_ca() == itemStack;
                if (livingEntity.func_184614_ca().func_77973_b() instanceof GlazingTool) {
                    return flag && this.getMode(itemStack) == GlazingToolMode.UNBREAKABLE ? 1.0f : 0.0f;
                }
            }
            return 0.0f;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() || ((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("Mode: " + this.getMode(stack).getTitle()));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return (Boolean)Config.ENABLE_PANE_BREAK.get() != false && this.getMode(stack) == GlazingToolMode.BREAK || stack.func_77948_v();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            PlayerEntity player = context.func_195999_j();
            ItemStack itemstack = context.func_195996_i();
            BlockPos blockpos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            if (block instanceof GlassPane) {
                if (((Boolean)Config.ENABLE_PANE_BREAK.get()).booleanValue() && this.getMode(itemstack) == GlazingToolMode.BREAK) {
                    if (player != null && player.func_213453_ef()) {
                        world.func_217377_a(blockpos, false);
                        Block.func_180635_a((World)world, (BlockPos)blockpos, (ItemStack)block.getPickBlock(blockstate, null, (IBlockReader)world, blockpos, player));
                    }
                } else if (((Boolean)Config.ENABLE_UNBREAKABLE.get()).booleanValue() && this.getMode(itemstack) == GlazingToolMode.UNBREAKABLE) {
                    world.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((IProperty)GlassPane.UNBREAKABLE, (Comparable)Boolean.valueOf((Boolean)blockstate.func_177229_b((IProperty)GlassPane.UNBREAKABLE) == false)));
                } else {
                    world.func_175656_a(blockpos, block.rotate(blockstate, (IWorld)world, blockpos, player != null && player.func_213453_ef() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90));
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.func_201670_d()) {
            ItemStack stack = playerIn.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof GlazingTool) {
                GlazingToolMode mode = this.advanceMode(stack);
                ((GlazingTool)stack.func_77973_b()).setMode(stack, mode);
                PacketHandler.sendToPlayer(new ModePacket(mode, EquipmentSlotType.MAINHAND), (ServerPlayerEntity)playerIn);
            } else {
                LOGGER.error("GlazingTool::onItemRightClick was triggered for an illegal item: " + stack);
            }
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public GlazingToolMode getMode(ItemStack stack) {
        return this.hasValidTag(stack) ? GlazingToolMode.byIndex(stack.func_77978_p().func_74762_e("glazing_tool_mode")) : GlazingToolMode.ROTATE;
    }

    public void setMode(ItemStack stack, GlazingToolMode mode) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a("glazing_tool_mode", mode.getIndex());
        stack.func_77982_d(tag);
    }

    public GlazingToolMode advanceMode(@Nonnull ItemStack stack) {
        GlazingToolMode newMode;
        GlazingToolMode mode = this.getMode(stack);
        if (mode != (newMode = this.getMode(stack).advanceMode())) {
            this.setMode(stack, newMode);
        }
        return this.getMode(stack);
    }

    private boolean hasValidTag(ItemStack stack) {
        if (stack == null || stack.func_77978_p() == null) {
            return false;
        }
        CompoundNBT tag = stack.func_196082_o();
        return tag.func_150297_b("glazing_tool_mode", 3);
    }
}

