/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.items;

import tv.mongotheelder.pitg.setup.Config;

public enum GlazingToolMode {
    ROTATE("Rotate", 0, true),
    UNBREAKABLE("Unbreakable", 1, (Boolean)Config.ENABLE_UNBREAKABLE.get()),
    BREAK("Break", 2, (Boolean)Config.ENABLE_PANE_BREAK.get());

    private final String title;
    private final int index;
    private boolean enabled;

    private GlazingToolMode(String title, int index, boolean enabled) {
        this.title = title;
        this.index = index;
        this.enabled = enabled;
    }

    public static void refresh() {
        GlazingToolMode.UNBREAKABLE.enabled = (Boolean)Config.ENABLE_UNBREAKABLE.get();
        GlazingToolMode.BREAK.enabled = (Boolean)Config.ENABLE_PANE_BREAK.get();
    }

    public String getTitle() {
        return this.title;
    }

    public int getIndex() {
        return this.index;
    }

    public static GlazingToolMode byIndex(int index) {
        for (GlazingToolMode m : GlazingToolMode.values()) {
            if (m.index != index || !m.enabled) continue;
            return m;
        }
        return ROTATE;
    }

    public GlazingToolMode advanceMode() {
        switch (this) {
            case ROTATE: {
                if (GlazingToolMode.UNBREAKABLE.enabled) {
                    return UNBREAKABLE;
                }
            }
            case UNBREAKABLE: {
                if (!GlazingToolMode.BREAK.enabled) break;
                return BREAK;
            }
        }
        return ROTATE;
    }
}

