/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.pitg.networking;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.pitg.Pitg;
import tv.mongotheelder.pitg.items.GlazingTool;
import tv.mongotheelder.pitg.items.GlazingToolMode;

public class ModePacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final GlazingToolMode mode;
    private final EquipmentSlotType slot;

    public ModePacket(GlazingToolMode mode, EquipmentSlotType slot) {
        this.mode = mode;
        this.slot = slot;
    }

    public static void handle(ModePacket msg, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = Pitg.proxy.getPlayer(context);
        if (player == null) {
            LOGGER.error("Received a Glazing Tool mode change packet from a null player");
            return;
        }
        context.get().enqueueWork(() -> {
            ItemStack stack = player.func_184582_a(msg.slot);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof GlazingTool) {
                ((GlazingTool)stack.func_77973_b()).setMode(stack, msg.mode);
                LOGGER.debug("Setting mode on client to " + (Object)((Object)((GlazingTool)stack.func_77973_b()).getMode(stack)));
            } else {
                LOGGER.warn("Glazing Tool mode change could not locate the tool in the player");
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(ModePacket pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.mode);
        buf.func_179249_a((Enum)pkt.slot);
    }

    public static ModePacket decode(PacketBuffer buf) {
        return new ModePacket((GlazingToolMode)buf.func_179257_a(GlazingToolMode.class), (EquipmentSlotType)buf.func_179257_a(EquipmentSlotType.class));
    }
}

