/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.ModLoader;

public class CombTextureLoader
implements PreparableReloadListener,
Predicate<ResourceLocation> {
    public static final CombTextureLoader INSTANCE = new CombTextureLoader();
    private final String folder;
    private final int trim = "textures".length() + 1;
    private final String extension;
    protected Set<ResourceLocation> resources = ImmutableSet.of();

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller1, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            if (ModLoader.isLoadingStateValid()) {
                this.onReloadSafe(resourceManager);
            }
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0));
    }

    public CombTextureLoader() {
        this.folder = "textures/item/honeycombs";
        this.extension = ".png";
    }

    public void onReloadSafe(ResourceManager manager) {
        int extensionLength = this.extension.length();
        this.resources = manager.m_6540_(this.folder, loc -> loc.endsWith(this.extension) && CombTextureLoader.isPathValid(loc)).stream().map(location -> {
            String path = location.m_135815_();
            return new ResourceLocation(location.m_135827_(), path.substring(this.trim, path.length() - extensionLength));
        }).collect(Collectors.toSet());
    }

    private static boolean isPathValid(String path) {
        return path.chars().allMatch(c -> c >= 48 && c <= 57 || c >= 97 && c <= 122 || c == 95 || c == 47 || c == 46 || c == 45);
    }

    @Override
    public boolean test(ResourceLocation location) {
        return this.resources.contains(location);
    }

    public void clear() {
        this.resources = ImmutableSet.of();
    }

    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (InventoryMenu.f_39692_.equals((Object)event.getMap().m_118330_())) {
            this.resources.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }
}

