/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.advancements.criterion;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.common.block.Feeder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HoneyloggedTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("productivebees", "honeylogged");

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Nullable
    private static Block getBlockCriteria(JsonObject jsonObject) {
        if (jsonObject.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
            return (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
        }
        return null;
    }

    public void trigger(ServerPlayer player, BlockPos pos, ItemStack item) {
        BlockState blockstate = player.m_9236_().m_8055_(pos);
        this.m_66234_(player, trigger -> trigger.test(blockstate));
    }

    @Nonnull
    protected Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite andPredicate, DeserializationContext conditionArrayParser) {
        Block block = HoneyloggedTrigger.getBlockCriteria(jsonObject);
        return new Instance(block);
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Block block;

        public Instance(@Nullable Block block) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.block = block;
        }

        public boolean test(BlockState state) {
            if (this.block != null && state.m_60734_() != this.block) {
                return false;
            }
            return state.m_61138_((Property)Feeder.HONEYLOGGED) && (Boolean)state.m_61143_((Property)Feeder.HONEYLOGGED) != false;
        }

        @Nonnull
        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject jsonobject = super.m_7683_(serializer);
            if (this.block != null) {
                jsonobject.addProperty("block", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.block)).toString());
            }
            return jsonobject;
        }
    }
}

