/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class SolitaryNest
extends AdvancedBeehiveAbstract {
    List<BeeSpawningRecipe> recipes = new ArrayList<BeeSpawningRecipe>();

    public SolitaryNest(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : SolitaryNest.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModTileEntityTypes.SOLITARY_NEST.get()), SolitaryNestBlockEntity::tick);
    }

    @Override
    public int getMaxHoneyLevel() {
        return 0;
    }

    public Entity getNestingBeeType(Level world, Biome biome) {
        List<BeeSpawningRecipe> spawningRecipes = this.getSpawningRecipes(world, biome);
        if (!spawningRecipes.isEmpty()) {
            BeeSpawningRecipe spawningRecipe = spawningRecipes.get(ProductiveBees.rand.nextInt(spawningRecipes.size()));
            BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(world.f_46441_.nextInt(spawningRecipe.output.size())).get();
            Entity bee = beeIngredient.getBeeEntity().m_20615_(world);
            if (bee instanceof ConfigurableBee) {
                ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)bee).setAttributes();
            }
            return bee;
        }
        return null;
    }

    public List<BeeSpawningRecipe> getSpawningRecipes(Level world, Biome biome) {
        if (this.recipes.isEmpty()) {
            HashMap allRecipes = new HashMap();
            allRecipes.putAll(world.m_7465_().m_44054_(BeeSpawningBigRecipe.BEE_SPAWNING));
            allRecipes.putAll(world.m_7465_().m_44054_(BeeSpawningRecipe.BEE_SPAWNING));
            ItemStack nestItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.getRegistryName()));
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeSpawningRecipe recipe = (BeeSpawningRecipe)entry.getValue();
                if (!recipe.matches(nestItem)) continue;
                this.recipes.add(recipe);
            }
        }
        ArrayList<BeeSpawningRecipe> spawningRecipes = new ArrayList<BeeSpawningRecipe>();
        if (!this.recipes.isEmpty()) {
            for (BeeSpawningRecipe recipe : this.recipes) {
                if ((!recipe.biomes.isEmpty() || world.m_46472_() != Level.f_46428_) && !recipe.biomes.contains(biome.m_47567_().m_47645_())) continue;
                spawningRecipes.add(recipe);
            }
        }
        return spawningRecipes;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SolitaryNestBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext itemUseContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)itemUseContext.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    public boolean canRepopulateIn(Level world, Biome biome) {
        return !this.getSpawningRecipes(world, biome).isEmpty();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            SolitaryNestBlockEntity tileEntity = (SolitaryNestBlockEntity)world.m_7702_(pos);
            ItemStack heldItem = player.m_21120_(hand);
            if (tileEntity != null && heldItem.m_41720_().equals(ModItems.HONEY_TREAT.get())) {
                boolean itemUse = false;
                int currentCooldown = tileEntity.getNestTickCooldown();
                if (currentCooldown <= 0) {
                    if (tileEntity.canRepopulate()) {
                        tileEntity.setNestCooldown((Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get());
                        itemUse = true;
                    }
                } else {
                    tileEntity.setNestCooldown((int)((double)currentCooldown * 0.9));
                    itemUse = true;
                }
                if (itemUse) {
                    world.m_46796_(2005, pos, 0);
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, heldItem);
                }
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128451_("spawnCount") >= (Integer)ProductiveBeesConfig.BEES.cuckooSpawnCount.get()) {
            tooltip.add((Component)new TranslatableComponent("productivebees.hive.tooltip.nest_inactive").m_130940_(ChatFormatting.BOLD));
        }
    }
}

