/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.HoarderBee;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.handler.bee.InhabitantStorage;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class AdvancedBeehiveBlockEntityAbstract
extends BeehiveBlockEntity {
    public int MAX_BEES = 3;
    private LazyOptional<IInhabitantStorage> beeHandler = LazyOptional.of(this::createBeeHandler);
    private BlockEntityType<?> tileEntityType;
    protected int tickCounter = 0;

    public AdvancedBeehiveBlockEntityAbstract(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(pos, state);
        this.tileEntityType = tileEntityType;
    }

    @Nonnull
    public BlockEntityType<?> m_58903_() {
        return this.tileEntityType == null ? super.m_58903_() : this.tileEntityType;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedBeehiveBlockEntityAbstract blockEntity) {
        if (blockEntity.tickCounter++ % 100 == 0) {
            AdvancedBeehiveBlockEntityAbstract.tickBees(level, pos, state, blockEntity);
            blockEntity.tickCounter = 0;
        }
        if (level.m_5822_().nextDouble() < 0.005) {
            blockEntity.beeHandler.ifPresent(h -> {
                if (h.getInhabitants().size() > 0) {
                    double x = (double)pos.m_123341_() + 0.5;
                    double y = pos.m_123342_();
                    double z = (double)pos.m_123343_() + 0.5;
                    level.m_6263_(null, x, y, z, SoundEvents.f_11698_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
    }

    private static void tickBees(Level level, BlockPos hivePos, BlockState state, AdvancedBeehiveBlockEntityAbstract blockEntity) {
        blockEntity.beeHandler.ifPresent(h -> {
            Iterator<Inhabitant> inhabitantIterator = h.getInhabitants().iterator();
            while (inhabitantIterator.hasNext()) {
                Inhabitant inhabitant = inhabitantIterator.next();
                if (inhabitant.ticksInHive > inhabitant.minOccupationTicks) {
                    BeehiveBlockEntity.BeeReleaseStatus beeState;
                    BeehiveBlockEntity.BeeReleaseStatus beeReleaseStatus = beeState = inhabitant.nbt.m_128471_("HasNectar") ? BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED : BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED;
                    if (!AdvancedBeehiveBlockEntityAbstract.releaseBee(level, hivePos, state, blockEntity, inhabitant.nbt.m_6426_(), null, beeState)) continue;
                    inhabitantIterator.remove();
                    continue;
                }
                inhabitant.ticksInHive += blockEntity.tickCounter;
            }
        });
    }

    protected int getTimeInHive(boolean hasNectar, @Nullable Bee beeEntity) {
        if (beeEntity instanceof ProductiveBee) {
            return ((ProductiveBee)beeEntity).getTimeInHive(hasNectar);
        }
        return hasNectar ? (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() : (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() / 2;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        super.m_6596_();
    }

    public void m_58748_(@Nullable Player player, BlockState blockState, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        ArrayList releasedBees = Lists.newArrayList();
        this.beeHandler.ifPresent(h -> h.getInhabitants().removeIf(tag -> AdvancedBeehiveBlockEntityAbstract.releaseBee(this.f_58857_, this.m_58899_(), blockState, this, tag.nbt.m_6426_(), releasedBees, beeState)));
        if (player != null) {
            for (Entity entity : releasedBees) {
                Entity entity2 = entity;
                if (!(entity2 instanceof Bee)) continue;
                Bee beeEntity = (Bee)entity2;
                if (!(player.m_142538_().m_123331_((Vec3i)entity.m_142538_()) <= 16.0)) continue;
                if (!this.m_58777_()) {
                    int temper;
                    if (beeEntity instanceof ProductiveBee && ((temper = ((ProductiveBee)beeEntity).getAttributeValue(BeeAttributes.TEMPER).intValue()) == 0 || temper == 1 && (double)ProductiveBees.rand.nextFloat() < 0.5)) {
                        beeEntity.m_27915_(400);
                        break;
                    }
                    beeEntity.m_6710_((LivingEntity)player);
                    continue;
                }
                beeEntity.m_27915_(400);
            }
        }
    }

    public boolean m_58774_() {
        return this.getBeeList().isEmpty();
    }

    public int m_58776_() {
        return this.getBeeList().size();
    }

    public boolean m_58775_() {
        return this.m_58776_() == this.MAX_BEES;
    }

    public boolean acceptsBee(Bee bee) {
        return true;
    }

    public void m_58744_(Entity entity, boolean hasNectar, int ticksInHive) {
        if (entity instanceof Bee && this.acceptsBee((Bee)entity)) {
            this.beeHandler.ifPresent(h -> {
                if (h.getInhabitants().size() < this.MAX_BEES) {
                    entity.m_8127_();
                    entity.m_20153_();
                    CompoundTag compoundNBT = new CompoundTag();
                    entity.m_20223_(compoundNBT);
                    Bee beeEntity = (Bee)entity;
                    h.addInhabitant(new Inhabitant(compoundNBT, ticksInHive, this.getTimeInHive(hasNectar, beeEntity), ((Bee)entity).m_27851_(), entity.m_7755_().getString()));
                    if (beeEntity.m_27852_() && (!this.hasSavedFlowerPos() || this.f_58857_ != null && this.f_58857_.f_46441_.nextBoolean())) {
                        this.f_58733_ = beeEntity.m_27851_();
                    }
                    if (this.f_58857_ != null) {
                        BlockPos pos = this.m_58899_();
                        this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    entity.m_146870_();
                }
            });
        }
    }

    public void m_58741_(@Nonnull Entity beeEntity, boolean hasNectar) {
        this.m_58744_(beeEntity, hasNectar, 0);
    }

    public static boolean releaseBee(Level level, BlockPos hivePos, BlockState state, AdvancedBeehiveBlockEntityAbstract blockEntity, CompoundTag tag, @Nullable List<Entity> releasedBees, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        boolean stayInside;
        if (state.m_60734_().equals(Blocks.f_50016_) || level == null) {
            return false;
        }
        boolean bl = stayInside = level.m_46472_() == Level.f_46428_ && (level.m_46462_() && tag.m_128451_("bee_behavior") == 0 || level.m_46471_() && (beeState != BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY || tag.m_128451_("bee_weather_tolerance") == 0));
        if (!stayInside) {
            boolean isPositionBlocked;
            tag.m_128473_("Passengers");
            tag.m_128473_("Leash");
            tag.m_128473_("UUID");
            Direction direction = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (Direction)state.m_61143_((Property)BeehiveBlock.f_49563_);
            BlockPos frontPos = hivePos.m_142300_(direction);
            boolean bl2 = isPositionBlocked = !level.m_8055_(frontPos).m_60812_((BlockGetter)level, frontPos).m_83281_();
            if (!isPositionBlocked || beeState == BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY) {
                boolean spawned = false;
                Bee beeEntity = (Bee)EntityType.m_20645_((CompoundTag)tag, (Level)level, spawnedEntity -> spawnedEntity);
                if (beeEntity != null) {
                    AtomicBoolean hasOffloaded = new AtomicBoolean(true);
                    if (beeEntity instanceof HoarderBee && ((HoarderBee)beeEntity).holdsItem()) {
                        blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                            ((HoarderBee)beeEntity).emptyIntoInventory((InventoryHandlerHelper.ItemHandler)((Object)inv));
                            if (!((HoarderBee)beeEntity).isInventoryEmpty()) {
                                hasOffloaded.set(false);
                            }
                        });
                    }
                    if ((spawned = AdvancedBeehiveBlockEntityAbstract.spawnBeeInWorldAtPosition((ServerLevel)level, (Entity)beeEntity, hivePos, direction, null)) && hasOffloaded.get()) {
                        if (blockEntity.hasSavedFlowerPos() && !beeEntity.m_27852_() && (beeEntity.m_20078_().contains("dye_bee") || level.f_46441_.nextFloat() <= 0.9f)) {
                            beeEntity.m_27876_(blockEntity.f_58733_);
                        }
                        blockEntity.beeReleasePostAction(level, beeEntity, state, beeState);
                        if (releasedBees != null) {
                            releasedBees.add((Entity)beeEntity);
                        }
                    }
                }
                return spawned;
            }
            return false;
        }
        return false;
    }

    protected void beeReleasePostAction(Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        int maxHoneyLevel;
        int honeyLevel;
        beeEntity.m_27853_();
        beeEntity.m_5634_(2.0f);
        AdvancedBeehiveBlockEntityAbstract.applyHiveTime(this.getTimeInHive(beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED, beeEntity), beeEntity);
        beeEntity.m_27864_();
        if (beeEntity instanceof ProductiveBee && ((ProductiveBee)beeEntity).hasConverted()) {
            return;
        }
        if (beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED && state.m_61138_((Property)BeehiveBlock.f_49564_) && (honeyLevel = AdvancedBeehiveBlockEntityAbstract.m_58752_((BlockState)state)) < (maxHoneyLevel = AdvancedBeehiveBlockEntityAbstract.getMaxHoneyLevel(state))) {
            int levelIncrease;
            int n = levelIncrease = level.f_46441_.nextInt(100) == 0 ? 2 : 1;
            if (honeyLevel + levelIncrease > maxHoneyLevel) {
                --levelIncrease;
            }
            level.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(honeyLevel + levelIncrease)));
        }
    }

    private static void applyHiveTime(int ticksInHive, Bee beeEntity) {
        int i = beeEntity.m_146764_();
        if (i < 0) {
            beeEntity.m_146762_(Math.min(0, i + ticksInHive));
        } else if (i > 0) {
            beeEntity.m_146762_(Math.max(0, i - ticksInHive));
        }
        beeEntity.m_27853_();
    }

    private boolean hasSavedFlowerPos() {
        return this.f_58733_ != null;
    }

    public static int getMaxHoneyLevel(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof AdvancedBeehiveAbstract ? ((AdvancedBeehiveAbstract)block).getMaxHoneyLevel() : 5;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag beeTag = tag.m_128469_("Bees");
        this.beeHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((net.minecraft.nbt.Tag)beeTag));
    }

    @Nonnull
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.beeHandler.ifPresent(h -> {
            tag.m_128473_("Bees");
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("Bees", (net.minecraft.nbt.Tag)compound);
        });
        return tag;
    }

    @Nonnull
    public static ListTag getBeeListAsNBTList(AdvancedBeehiveBlockEntityAbstract blockEntity) {
        return blockEntity.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitantListAsListNBT).orElse(new ListTag());
    }

    public static boolean spawnBeeInWorldAtPosition(ServerLevel world, Entity entity, BlockPos pos, Direction direction, @Nullable Integer age) {
        BlockPos offset = pos.m_142300_(direction);
        boolean isPositionBlocked = !world.m_8055_(offset).m_60812_((BlockGetter)world, offset).m_83281_();
        float width = entity.m_20205_();
        double spawnOffset = isPositionBlocked ? 0.0 : 0.55 + (double)(width / 2.0f);
        double x = (double)pos.m_123341_() + 0.5 + spawnOffset * (double)direction.m_122429_();
        double y = (double)pos.m_123342_() + 0.5 - (double)(entity.m_20206_() / 2.0f);
        double z = (double)pos.m_123343_() + 0.5 + spawnOffset * (double)direction.m_122431_();
        entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        if (age != null && entity instanceof Bee) {
            ((Bee)entity).m_146762_(age.intValue());
        }
        if (entity.m_6095_().m_20609_((Tag)EntityTypeTags.f_13122_)) {
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
            CompoundTag tag = new CompoundTag();
            if (entity instanceof ConfigurableBee) {
                tag.m_128359_("type", ((ConfigurableBee)entity).getBeeType());
            }
            return world.m_7967_(entity);
        }
        return false;
    }

    public List<Inhabitant> getBeeList() {
        return this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitants).orElse(new ArrayList());
    }

    private IInhabitantStorage createBeeHandler() {
        return new InhabitantStorage(){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                AdvancedBeehiveBlockEntityAbstract.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBee.BEE) {
            return this.beeHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public static class Inhabitant {
        public final CompoundTag nbt;
        public int ticksInHive;
        public final int minOccupationTicks;
        public final BlockPos flowerPos;
        public final String localizedName;

        public Inhabitant(CompoundTag nbt, int ticksInHive, int minOccupationTicks, BlockPos flowerPos, String localizedName) {
            nbt.m_128473_("UUID");
            this.nbt = nbt;
            this.ticksInHive = ticksInHive;
            this.minOccupationTicks = minOccupationTicks;
            this.flowerPos = flowerPos;
            this.localizedName = localizedName;
        }

        public String toString() {
            return "Bee{ticksInHive=" + this.ticksInHive + "flowerPos=" + this.flowerPos + ", minOccupationTicks=" + this.minOccupationTicks + ", nbt=" + this.nbt + "}";
        }
    }
}

