/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.Bottler;
import cy.jdkdigital.productivebees.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.container.BottlerContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BottlerBlockEntity
extends FluidTankBlockEntity {
    protected int tickCounter = 0;
    public int fluidId = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, this){

        @Override
        public boolean isContainerItem(Item item) {
            return item == Items.f_42590_ || item == Items.f_42446_ || item == Items.f_42784_;
        }
    });
    public LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BottlerBlockEntity.this.fluidId = Registry.f_122822_.m_7447_((Object)this.getFluid().getFluid());
            BottlerBlockEntity.this.m_6596_();
        }
    });

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.inventoryHandler.ifPresent(inv -> {
                ItemStack stack = inv.getStackInSlot(0);
                boolean hasBottle = !stack.m_41619_() && stack.m_41720_().equals(Items.f_42590_);
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Bottler.HAS_BOTTLE, (Comparable)Boolean.valueOf(hasBottle)), 3);
            });
        }
    }

    public BottlerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.BOTTLER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BottlerBlockEntity blockEntity) {
        List bees;
        if (++blockEntity.tickCounter % 10 == 0 && state.m_60734_() == Blocks.f_50040_ && state.m_61143_((Property)DirectionalBlock.f_52588_) == Direction.DOWN && !(bees = level.m_45976_(Bee.class, new AABB(pos).m_82363_(0.0, 1.0, 0.0))).isEmpty()) {
            Bee bee = (Bee)bees.iterator().next();
            blockEntity.inventoryHandler.ifPresent(inv -> {
                ItemStack bottles = inv.getStackInSlot(0);
                if (!bottles.m_41619_() && bottles.m_41720_().equals(Items.f_42590_) && !bee.m_6162_() && bee.m_6084_()) {
                    ItemStack geneBottle = GeneBottle.getStack((Entity)bee);
                    Block.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)geneBottle);
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    bee.m_6074_();
                    bottles.m_41774_(1);
                }
            });
        }
        FluidTankBlockEntity.tick(level, pos, state, blockEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        Fluid fluid = this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        this.fluidId = Registry.f_122822_.m_7447_((Object)fluid);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.BOTTLER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new BottlerContainer(windowId, playerInventory, this);
    }
}

