/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CentrifugeBlockEntity
extends FluidTankBlockEntity
implements UpgradeableBlockEntity {
    private CentrifugeRecipe currentRecipe = null;
    public int recipeProgress = 0;
    public int fluidId = 0;
    public int transferCooldown = -1;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, this){

        @Override
        public boolean isContainerItem(Item item) {
            return item == Items.f_42590_ || item == Items.f_42446_;
        }

        @Override
        public boolean isInputSlotItem(int slot, Item item) {
            boolean isProcessableItem = item.equals(ModItems.GENE_BOTTLE.get()) || item.equals(ModItems.HONEY_TREAT.get()) || CentrifugeBlockEntity.this.canProcessItemStack(new ItemStack((ItemLike)item));
            return isProcessableItem && slot == 1 || !isProcessableItem && super.isInputSlotItem(slot, item);
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CentrifugeBlockEntity.this.fluidId = Registry.f_122822_.m_7447_((Object)this.getFluid().getFluid());
            CentrifugeBlockEntity.this.m_6596_();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));

    public CentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.CENTRIFUGE.get(), pos, state);
    }

    public CentrifugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double combBlockUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) * (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier + combBlockUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CentrifugeBlockEntity blockEntity) {
        blockEntity.inventoryHandler.ifPresent(invHandler -> {
            if (!invHandler.getStackInSlot(1).m_41619_() && blockEntity.canOperate()) {
                ItemStack invItem = invHandler.getStackInSlot(1);
                if (invItem.m_41720_().equals(ModItems.GENE_BOTTLE.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime();
                    if (++blockEntity.recipeProgress >= totalTime) {
                        blockEntity.completeGeneProcessing((IItemHandlerModifiable)invHandler);
                        blockEntity.recipeProgress = 0;
                        blockEntity.m_6596_();
                    }
                } else if (invItem.m_41720_().equals(ModItems.HONEY_TREAT.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime();
                    if (++blockEntity.recipeProgress >= totalTime) {
                        blockEntity.completeTreatProcessing((IItemHandlerModifiable)invHandler);
                        blockEntity.recipeProgress = 0;
                        blockEntity.m_6596_();
                    }
                } else {
                    CentrifugeRecipe recipe = blockEntity.getRecipe((IItemHandlerModifiable)invHandler);
                    if (blockEntity.canProcessRecipe(recipe, (IItemHandlerModifiable)invHandler)) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                        int totalTime = blockEntity.getProcessingTime();
                        if (++blockEntity.recipeProgress >= totalTime) {
                            blockEntity.completeRecipeProcessing(recipe, (IItemHandlerModifiable)invHandler);
                            blockEntity.recipeProgress = 0;
                            blockEntity.m_6596_();
                        }
                    }
                }
            } else {
                blockEntity.recipeProgress = 0;
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
            }
            if (((Boolean)ProductiveBeesConfig.GENERAL.centrifugeHopperMode.get()).booleanValue() && --blockEntity.transferCooldown <= 0) {
                blockEntity.transferCooldown = 22;
                blockEntity.suckInItems((IItemHandlerModifiable)invHandler);
            }
        });
        FluidTankBlockEntity.tick(level, pos, state, blockEntity);
    }

    private void suckInItems(IItemHandlerModifiable invHandler) {
        for (ItemEntity itemEntity : this.getCaptureItems()) {
            ItemStack itemStack = itemEntity.m_32055_();
            if (!this.canProcessItemStack(itemStack) && !itemStack.m_41720_().equals(ModItems.GENE_BOTTLE.get()) && (!itemStack.m_41720_().equals(ModItems.HONEY_TREAT.get()) || !HoneyTreat.hasGene(itemStack))) continue;
            CentrifugeBlockEntity.captureItem(invHandler, itemEntity);
        }
    }

    private List<ItemEntity> getCaptureItems() {
        assert (this.f_58857_ != null);
        return Centrifuge.COLLECTION_AREA_SHAPE.m_83299_().stream().flatMap(blockPos -> this.f_58857_.m_6443_(ItemEntity.class, blockPos.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    private static void captureItem(IItemHandlerModifiable invHandler, ItemEntity itemEntity) {
        ItemStack insertStack = itemEntity.m_32055_().m_41777_();
        ItemStack leftoverStack = invHandler.insertItem(1, insertStack, false);
        if (leftoverStack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(leftoverStack);
        }
    }

    protected boolean canOperate() {
        return true;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean canProcessItemStack(ItemStack stack) {
        InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(2, null);
        inv.setStackInSlot(1, stack);
        CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)inv);
        return recipe != null;
    }

    private CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        ItemStack input = inputHandler.getStackInSlot(1);
        if (input.m_41619_() || input == ItemStack.f_41583_ || this.f_58857_ == null) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.m_5818_((Container)new RecipeWrapper(inputHandler), this.f_58857_)) {
            return this.currentRecipe;
        }
        this.currentRecipe = BeeHelper.getCentrifugeRecipe(this.f_58857_.m_7465_(), inputHandler);
        Map allRecipes = this.f_58857_.m_7465_().m_44054_(CentrifugeRecipe.CENTRIFUGE);
        RecipeWrapper inv = new RecipeWrapper(inputHandler);
        for (Map.Entry entry : allRecipes.entrySet()) {
            CentrifugeRecipe recipe = (CentrifugeRecipe)entry.getValue();
            if (!recipe.m_5818_((Container)inv, this.f_58857_)) continue;
            this.currentRecipe = recipe;
            break;
        }
        return this.currentRecipe;
    }

    protected boolean canProcessRecipe(@Nullable CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            recipe.getRecipeOutputs().forEach((key, value) -> {
                ItemStack item = new ItemStack((ItemLike)key.m_41720_(), value.get(1).m_7047_());
                outputList.add(item);
            });
            boolean fluidFlag = false;
            Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
            if (fluidOutput != null) {
                fluidFlag = this.fluidInventory.map(h -> h.getFluidInTank(0).isEmpty() || h.getFluidInTank(0).getFluid().equals(fluidOutput.getFirst())).orElse(false);
            }
            return fluidFlag && ((InventoryHandlerHelper.ItemHandler)invHandler).canFitStacks(outputList);
        }
        return false;
    }

    private void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (this.canProcessRecipe(recipe, invHandler)) {
            recipe.getRecipeOutputs().forEach((itemStack, recipeValues) -> {
                if (ProductiveBees.rand.nextInt(100) <= recipeValues.get(2).m_7047_()) {
                    int count = Mth.m_14072_((Random)ProductiveBees.rand, (int)Mth.m_14143_((float)recipeValues.get(0).m_7047_()), (int)Mth.m_14143_((float)recipeValues.get(1).m_7047_()));
                    itemStack.m_41764_(count);
                    ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(itemStack.m_41777_());
                }
            });
            invHandler.getStackInSlot(1).m_41774_(1);
            Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
            if (fluidOutput != null) {
                this.fluidInventory.ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)fluidOutput.getFirst(), ((Integer)fluidOutput.getSecond()).intValue()), IFluidHandler.FluidAction.EXECUTE));
            }
        }
    }

    private void completeGeneProcessing(IItemHandlerModifiable invHandler) {
        ItemStack geneBottle = invHandler.getStackInSlot(1);
        CompoundTag entityData = GeneBottle.getGenes(geneBottle);
        if (entityData == null) {
            return;
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("productivity");
        attributes.add("weather_tolerance");
        attributes.add("behavior");
        attributes.add("endurance");
        attributes.add("temper");
        double chance = (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.geneExtractChance.get();
        for (String attributeName : attributes) {
            if (!(ProductiveBees.rand.nextDouble() <= chance)) continue;
            int value = entityData.m_128451_("bee_" + attributeName);
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(BeeAttributes.getAttributeByName(attributeName), value));
        }
        if (ProductiveBees.rand.nextDouble() <= chance) {
            int typePurity = (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.typeGenePurity.get();
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(entityData.m_128461_("type"), ProductiveBees.rand.nextInt(Math.max(0, typePurity - 5)) + 10));
        }
        invHandler.getStackInSlot(1).m_41774_(1);
    }

    private void completeTreatProcessing(IItemHandlerModifiable invHandler) {
        ItemStack honeyTreat = invHandler.getStackInSlot(1);
        ListTag genes = HoneyTreat.getGenes(honeyTreat);
        if (!genes.isEmpty()) {
            for (Tag inbt : genes) {
                ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                if (((CompoundTag)inbt).m_128441_("purity")) {
                    int purity = ((CompoundTag)inbt).m_128451_("purity");
                    Gene.setPurity(insertedGene, purity);
                }
                ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(insertedGene);
            }
        }
        invHandler.getStackInSlot(1).m_41774_(1);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.recipeProgress = tag.m_128451_("RecipeProgress");
        Fluid fluid = this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        this.fluidId = Registry.f_122822_.m_7447_((Object)fluid);
    }

    @Override
    @Nonnull
    public CompoundTag m_6945_(CompoundTag tag) {
        tag = super.m_6945_(tag);
        tag.m_128405_("RecipeProgress", this.recipeProgress);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.CENTRIFUGE.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CentrifugeContainer(windowId, playerInventory, this);
    }
}

