/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.FeederContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FeederBlockEntity
extends CapabilityBlockEntity {
    private int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(3, this){

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            return true;
        }
    });

    public FeederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.FEEDER.get(), pos, state);
    }

    public Block getRandomBlockFromInventory(Tag<Block> tag) {
        return this.inventoryHandler.map(h -> {
            ArrayList<Block> possibleBlocks = new ArrayList<Block>();
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                Block itemBlock;
                Item slotItem = h.getStackInSlot(slot).m_41720_();
                if (!(slotItem instanceof BlockItem) || !tag.m_8110_((Object)(itemBlock = ((BlockItem)slotItem).m_40614_()))) continue;
                possibleBlocks.add(itemBlock);
            }
            return (Block)possibleBlocks.get(ProductiveBees.rand.nextInt(possibleBlocks.size()));
        }).orElse(Blocks.f_50016_);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.FEEDER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new FeederContainer(windowId, playerInventory, this);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level instanceof ServerLevel && blockEntity instanceof FeederBlockEntity && ++((FeederBlockEntity)blockEntity).tickCounter % 164 == 0 && ((Boolean)state.m_61143_((Property)Feeder.HONEYLOGGED)).booleanValue()) {
            List entities = level.m_45976_(Bee.class, new AABB(pos));
            for (Bee entity : entities) {
                if (entity == null) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 80, 0, false, true));
            }
        }
    }
}

