/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.PoweredCentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class PoweredCentrifugeBlockEntity
extends CentrifugeBlockEntity {
    public LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    public PoweredCentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.POWERED_CENTRIFUGE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredCentrifugeBlockEntity blockEntity) {
        CentrifugeBlockEntity.tick(level, pos, state, blockEntity);
        if (((Boolean)state.m_61143_((Property)Centrifuge.RUNNING)).booleanValue() && level instanceof ServerLevel) {
            blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false));
        }
    }

    protected double getEnergyConsumptionModifier() {
        double combBlockUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) * (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier + combBlockUpgradeModifier);
    }

    @Override
    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePoweredProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    @Override
    protected boolean canOperate() {
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        return energy >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.POWERED_CENTRIFUGE.get()).m_7705_());
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new PoweredCentrifugeContainer(windowId, playerInventory, this);
    }
}

