/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeEffect;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ConfigurableBee
extends ProductiveBee
implements IEffectBeeEntity {
    private int attackCooldown = 0;
    public int breathCollectionCooldown = 600;
    private int teleportCooldown = 250;
    private static final Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();
    public static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ConfigurableBee.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public ConfigurableBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beehiveInterests = poiType -> poiType == PoiType.f_27348_ || poiType == ModPointOfInterestTypes.SOLITARY_HIVE.get() && this.isWild() || poiType == ModPointOfInterestTypes.SOLITARY_NEST.get() && this.isWild() || poiType == ModPointOfInterestTypes.DRACONIC_NEST.get() && this.isDraconic() || poiType == ModPointOfInterestTypes.SUGARBAG_NEST.get() && this.getBeeType().equals("productivebees:sugarbag");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityData, @Nullable CompoundTag tag) {
        String type = "";
        if (tag != null) {
            String string = tag.m_128441_("type") ? tag.m_128461_("type") : (type = tag.m_128441_("EntityTag") ? tag.m_128469_("EntityTag").m_128461_("type") : "");
        }
        if (type.equals("productivebees:ghostly") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.m_6593_((Component)new TextComponent("BooBee"));
        } else if (type.equals("productivebees:blitz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.m_6593_((Component)new TextComponent("King BitzBee"));
        } else if (type.equals("productivebees:basalz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.m_6593_((Component)new TextComponent("Queen BazBee"));
        } else if (type.equals("productivebees:blizz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.m_6593_((Component)new TextComponent("Shiny BizBee"));
        } else if (type.equals("productivebees:redstone") && ProductiveBees.rand.nextFloat() < 0.01f) {
            this.m_6593_((Component)new TextComponent("Redastone Bee"));
        } else if (type.equals("productivebees:destabilized_redstone") && ProductiveBees.rand.nextFloat() < 0.1f) {
            this.m_6593_((Component)new TextComponent("Destabilized RedaStone Bee"));
        }
        return super.m_6518_(world, difficulty, spawnReason, livingEntityData, tag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.teleportCooldown;
            if (--this.attackCooldown < 0) {
                this.attackCooldown = 0;
            }
            if (this.attackCooldown == 0 && this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0) {
                this.attackCooldown = this.getEffectCooldown(this.getAttributeValue(BeeAttributes.TEMPER));
                this.attackTarget(this.m_5448_());
            }
            if (--this.breathCollectionCooldown <= 0) {
                this.breathCollectionCooldown = 600;
                if (this.isDraconic() && this.f_19853_.m_46472_() == Level.f_46430_) {
                    this.m_27919_(true);
                }
            }
            if (this.f_19797_ % 20 == 0 && this.m_27856_() && this.isRedstoned()) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos beePosDown = this.m_142538_().m_6625_(i);
                    if (!this.f_19853_.m_46859_(beePosDown)) continue;
                    BlockState redstoneState = ((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()).m_49966_();
                    this.f_19853_.m_46597_(beePosDown, redstoneState);
                    this.f_19853_.m_6219_().m_5945_(beePosDown, (Object)redstoneState.m_60734_(), 20);
                }
            }
            if (this.f_19797_ > 100 && this.getBeeType().isEmpty() && this.m_6084_()) {
                this.m_6074_();
            }
        }
    }

    public void m_27779_(Level worldIn, double xMin, double xMax, double zMin, double zMax, double posY, ParticleOptions particleData) {
        NectarParticleType particle = switch (this.getParticleType()) {
            case "pop" -> (NectarParticleType)ModParticles.COLORED_POPPING_NECTAR.get();
            case "lava" -> (NectarParticleType)ModParticles.COLORED_LAVA_NECTAR.get();
            case "portal" -> (NectarParticleType)ModParticles.COLORED_PORTAL_NECTAR.get();
            case "rising" -> (NectarParticleType)ModParticles.COLORED_RISING_NECTAR.get();
            default -> (NectarParticleType)ModParticles.COLORED_FALLING_NECTAR.get();
        };
        if (this.hasParticleColor()) {
            particle.setColor(this.getParticleColor());
        } else {
            particle.setColor(new float[]{0.92f, 0.782f, 0.72f});
        }
        worldIn.m_7106_((ParticleOptions)particle, Mth.m_14139_((double)worldIn.f_46441_.nextDouble(), (double)xMin, (double)xMax), posY, Mth.m_14139_((double)worldIn.f_46441_.nextDouble(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }

    protected void m_8024_() {
        if (this.teleportCooldown <= 0) {
            if (null != this.f_21344_.m_26570_() && this.isTeleporting()) {
                int antiTeleportUpgrades;
                BlockEntity te;
                if (this.m_27854_() && (te = this.f_19853_.m_7702_(this.m_27855_())) instanceof AdvancedBeehiveBlockEntity && (antiTeleportUpgrades = ((AdvancedBeehiveBlockEntity)te).getUpgradeCount((Item)ModItems.UPGRADE_ANTI_TELEPORT.get())) > 0) {
                    this.teleportCooldown = 10000;
                    super.m_8024_();
                    return;
                }
                BlockPos pos = this.f_21344_.m_26570_().m_77406_();
                this.teleport(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
            this.teleportCooldown = 250;
        }
        super.m_8024_();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!this.isStringy() || state.m_60734_() != Blocks.f_50033_) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.m_6084_() && this.getNBTData().m_128441_("attackResponse")) {
            String attackResponse;
            switch (attackResponse = this.getNBTData().m_128461_("attackResponse")) {
                case "fire": {
                    target.m_7311_(200);
                }
                case "lava": {
                    this.f_19853_.m_7731_(target.m_142538_(), Blocks.f_49991_.m_49966_(), 11);
                }
            }
        }
    }

    public void setBeeType(String data) {
        this.f_19804_.m_135381_(TYPE, (Object)data);
    }

    @Override
    public String getBeeType() {
        return (String)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public void m_27925_(boolean hasStung) {
        if (!this.isStingless()) {
            super.m_27925_(hasStung);
        }
    }

    public void m_7350_(EntityDataAccessor<?> param) {
        if (TYPE.equals(param)) {
            this.m_6210_();
        }
        super.m_7350_(param);
    }

    public void setAttributes() {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("productivity")) {
            this.setAttributeValue(BeeAttributes.PRODUCTIVITY, nbt.m_128451_("productivity"));
        }
        if (nbt.m_128441_("temper")) {
            this.setAttributeValue(BeeAttributes.TEMPER, nbt.m_128451_("temper"));
        }
        if (nbt.m_128441_("endurance")) {
            this.setAttributeValue(BeeAttributes.ENDURANCE, nbt.m_128451_("endurance"));
        }
        if (nbt.m_128441_("behavior")) {
            this.setAttributeValue(BeeAttributes.BEHAVIOR, nbt.m_128451_("behavior"));
        }
        if (nbt.m_128441_("weather_tolerance")) {
            this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, nbt.m_128451_("weather_tolerance"));
        }
    }

    @Override
    public Color getColor(int tintIndex) {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("primaryColor")) {
            return tintIndex == 0 ? new Color(nbt.m_128451_("primaryColor")) : new Color(nbt.m_128451_("secondaryColor"));
        }
        return super.getColor(tintIndex);
    }

    @Nonnull
    protected Component m_5677_() {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("name")) {
            return new TranslatableComponent("entity.productivebees.bee_configurable", new Object[]{nbt.m_128461_("name")});
        }
        return super.m_5677_();
    }

    @Override
    public float getSizeModifier() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? nbt.m_128457_("size") : super.getSizeModifier();
    }

    @Override
    public boolean canSelfBreed() {
        CompoundTag nbt = this.getNBTData();
        return nbt.m_128471_("selfbreed");
    }

    @Override
    public boolean isFlowerBlock(Block flowerBlock) {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null) {
            if (nbt.m_128441_("flowerTag")) {
                Tag<Block> flowerTag = ModTags.getTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                return flowerTag.m_8110_((Object)flowerBlock);
            }
            if (nbt.m_128441_("flowerBlock")) {
                return flowerBlock.getRegistryName().toString().equals(nbt.m_128461_("flowerBlock"));
            }
        }
        return super.isFlowerBlock(flowerBlock);
    }

    @Override
    public Tag<Block> getNestingTag() {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && nbt.m_128441_("nestingPreference")) {
            return ModTags.getTag(new ResourceLocation(nbt.m_128461_("nestingPreference")));
        }
        return super.getNestingTag();
    }

    @Override
    public BeeEffect getBeeEffect() {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("effect")) {
            return new BeeEffect(nbt.m_128469_("effect"));
        }
        return super.getBeeEffect();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)"");
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.setBeeType(compound.m_128461_("type"));
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("type", this.getBeeType());
    }

    protected CompoundTag getNBTData() {
        CompoundTag nbt = BeeReloadListener.INSTANCE.getData(this.getBeeType());
        return nbt != null ? nbt : new CompoundTag();
    }

    public boolean hasBeeTexture() {
        return this.getNBTData().m_128441_("beeTexture");
    }

    public String getBeeTexture() {
        return this.getNBTData().m_128461_("beeTexture");
    }

    @Override
    public String getRenderer() {
        return this.getNBTData().m_128461_("renderer");
    }

    public String getRenderTransform() {
        return this.getNBTData().m_128461_("renderTransform");
    }

    public boolean useGlowLayer() {
        return this.getNBTData().m_128471_("useGlowLayer") || this.isRedstoned() && this.m_27856_();
    }

    private boolean isWild() {
        return this.getNBTData().m_128441_("nestingPreference");
    }

    public boolean isFireproof() {
        return this.getNBTData().m_128471_("fireproof");
    }

    public boolean isWithered() {
        return this.getNBTData().m_128471_("withered");
    }

    public boolean isTranslucent() {
        return this.getNBTData().m_128471_("translucent");
    }

    public boolean isBlinding() {
        return this.getNBTData().m_128471_("blinding");
    }

    public boolean isDraconic() {
        return this.getNBTData().m_128471_("draconic");
    }

    public boolean isRedstoned() {
        return this.getNBTData().m_128471_("redstoned");
    }

    public boolean isSlimy() {
        return this.getNBTData().m_128471_("slimy");
    }

    public boolean isTeleporting() {
        return this.getNBTData().m_128471_("teleporting");
    }

    public boolean isStringy() {
        return this.getNBTData().m_128471_("stringy");
    }

    public boolean isStingless() {
        return this.getNBTData().m_128471_("stingless");
    }

    public boolean hasMunchies() {
        return this.getNBTData().m_128471_("munchies");
    }

    public boolean isWaterproof() {
        return this.getNBTData().m_128471_("waterproof");
    }

    public String getParticleType() {
        return this.getNBTData().m_128461_("particleType");
    }

    public boolean hasParticleColor() {
        return this.getNBTData().m_128441_("particleColor");
    }

    public float[] getParticleColor() {
        return ConfigurableBee.getCacheColor(this.getNBTData().m_128451_("particleColor"));
    }

    public float[] getTertiaryColor() {
        CompoundTag nbt = this.getNBTData();
        return ConfigurableBee.getCacheColor(nbt.m_128451_("tertiaryColor"));
    }

    private static float[] getCacheColor(Integer color) {
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, new Color(color).getComponents(null));
        }
        return colorCache.get(color);
    }

    @Override
    public Map<MobEffect, Integer> getAggressiveEffects() {
        if (this.isWithered()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19615_, 350);
                }
            };
        }
        if (this.hasMunchies()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19612_, 530);
                }
            };
        }
        if (this.isBlinding()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19610_, 450);
                }
            };
        }
        return null;
    }

    @Override
    public boolean m_6673_(@Nonnull DamageSource source) {
        if (this.isWithered() && source.equals(DamageSource.f_19320_)) {
            return true;
        }
        if (this.isDraconic() && source.equals(DamageSource.f_19323_)) {
            return true;
        }
        if (this.isTranslucent() && source.equals(DamageSource.f_19321_)) {
            return true;
        }
        if (this.isWaterproof() && source.equals(DamageSource.f_19312_)) {
            return true;
        }
        if (this.isFireproof() && (source.equals(DamageSource.f_19309_) || source.equals(DamageSource.f_19305_) || source.equals(DamageSource.f_19307_) || source.equals(DamageSource.f_19308_))) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (this.isWithered()) {
            return effect.m_19544_() != MobEffects.f_19615_ && super.m_7301_(effect);
        }
        return super.m_7301_(effect);
    }

    private void teleport(double x, double y, double z) {
        boolean hasTeleported;
        EntityTeleportEvent.EnderEntity event;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        if (blockstate.m_60767_().m_76334_() && !MinecraftForge.EVENT_BUS.post((Event)(event = new EntityTeleportEvent.EnderEntity((LivingEntity)this, x, y, z))) && (hasTeleported = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 0.3f, 0.3f);
            this.m_5496_(SoundEvents.f_11852_, 0.2f, 1.0f);
        }
    }
}

