/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;

public class FarmerBee
extends ProductiveBee {
    public static final UUID FARMER_BEE_UUID = UUID.nameUUIDFromBytes("pb_farmer_bee".getBytes(StandardCharsets.UTF_8));
    private BlockPos targetHarvestPos = null;

    public FarmerBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_21345_.m_25352_(4, (Goal)new HarvestCropGoal());
        this.f_21345_.m_25352_(6, (Goal)new LocateCropGoal());
    }

    public List<BlockPos> findHarvestablesNearby(double distance) {
        return this.findHarvestablesNearby(this.m_142538_(), distance);
    }

    public List<BlockPos> findHarvestablesNearby(BlockPos pos, double distance) {
        List<BlockPos> list = BlockPos.m_121990_((BlockPos)pos.m_142022_(-distance, -distance + 2.0, -distance), (BlockPos)pos.m_142022_(distance, distance - 2.0, distance)).map(BlockPos::m_7949_).collect(Collectors.toList());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            BlockState state = this.f_19853_.m_8055_(blockPos);
            if (state.m_60734_() instanceof CropBlock && !((CropBlock)state.m_60734_()).m_7370_((BlockGetter)this.f_19853_, blockPos, state, false)) continue;
            iterator.remove();
        }
        return list;
    }

    public class HarvestCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            if (FarmerBee.this.targetHarvestPos != null && !this.positionIsHarvestable(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.m_21660_() && !FarmerBee.this.m_27816_(FarmerBee.this.targetHarvestPos, 2);
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void tick(Level level, BlockState state) {
            if (FarmerBee.this.targetHarvestPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    FarmerBee.this.targetHarvestPos = null;
                } else if (!FarmerBee.this.f_21344_.m_26571_()) {
                    BlockPos blockPos = FarmerBee.this.targetHarvestPos;
                    FarmerBee.this.f_21344_.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
                }
            }
        }

        private boolean positionIsHarvestable(BlockPos pos) {
            return !FarmerBee.this.findHarvestablesNearby(pos, 0.0).isEmpty();
        }
    }

    public class LocateCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            if (!FarmerBee.this.m_21660_()) {
                List<BlockPos> harvestablesNearby = FarmerBee.this.findHarvestablesNearby(10.0);
                Collections.shuffle(harvestablesNearby);
                if (!harvestablesNearby.isEmpty()) {
                    BlockPos nearest = null;
                    double nearestDistance = 0.0;
                    for (BlockPos pos : harvestablesNearby) {
                        double distance = pos.m_123331_((Vec3i)FarmerBee.this.m_142538_());
                        if (nearestDistance != 0.0 && !(distance <= nearestDistance)) continue;
                        nearestDistance = distance;
                        nearest = pos;
                    }
                    FarmerBee.this.targetHarvestPos = nearest;
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return FarmerBee.this.targetHarvestPos != null && FarmerBee.this.m_27854_() && !FarmerBee.this.m_21660_();
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            ++this.ticks;
            if (FarmerBee.this.targetHarvestPos != null) {
                if (this.ticks > 600) {
                    FarmerBee.this.targetHarvestPos = null;
                } else {
                    Vec3 vec3d = Vec3.m_82512_((Vec3i)FarmerBee.this.targetHarvestPos).m_82520_(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.m_82554_(FarmerBee.this.m_20182_());
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        FarmerBee.this.targetHarvestPos = null;
                    } else {
                        List<BlockPos> harvestablesNearby = FarmerBee.this.findHarvestablesNearby(0.0);
                        if (!harvestablesNearby.isEmpty() && FarmerBee.this.f_19853_ instanceof ServerLevel) {
                            BlockPos pos = harvestablesNearby.iterator().next();
                            if (ModList.get().isLoaded("quark") || ModList.get().isLoaded("pamhc2crops") || ModList.get().isLoaded("simplefarming") || ModList.get().isLoaded("reap")) {
                                FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)FarmerBee.this.f_19853_), (GameProfile)new GameProfile(FARMER_BEE_UUID, "farmer_bee"));
                                ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(FarmerBee.this.m_146892_(), FarmerBee.this.m_6374_(), pos, true));
                            } else {
                                FarmerBee.this.f_19853_.m_46961_(pos, true);
                            }
                            FarmerBee.this.targetHarvestPos = null;
                            FarmerBee.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            FarmerBee.this.m_21566_().m_6849_(nextTarget.f_82479_, nextTarget.f_82480_, nextTarget.f_82481_, 1.0);
        }
    }
}

