/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.BeeBombEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BeeBomb
extends Item {
    private static final String BEES_KEY = "productivebees_beebomb_bees";

    public BeeBomb(Item.Properties properties) {
        super(properties);
    }

    public static boolean isLoaded(ItemStack itemStack) {
        return BeeBomb.getBees(itemStack).size() > 0;
    }

    public static void addBee(ItemStack stack, ItemStack cage) {
        ListTag bees = BeeBomb.getBees(stack);
        bees.add((Object)cage.m_41783_());
        stack.m_41784_().m_128365_(BEES_KEY, (Tag)bees);
    }

    public static ListTag getBees(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        ListTag bees = new ListTag();
        if (tag != null && tag.m_128423_(BEES_KEY) instanceof ListTag) {
            bees = tag.m_128423_(BEES_KEY);
        }
        return bees;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            BeeBombEntity bombEntity = new BeeBombEntity(world, (LivingEntity)player);
            bombEntity.m_37446_(item);
            bombEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            world.m_7967_((Entity)bombEntity);
        }
        player.m_150109_().m_36057_(item);
        return InteractionResultHolder.m_19090_((Object)item);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        ListTag beeList = BeeBomb.getBees(stack);
        if (!beeList.isEmpty()) {
            if (Screen.m_96638_()) {
                list.add((Component)new TranslatableComponent("productivebees.hive.tooltip.bees").m_130940_(ChatFormatting.DARK_AQUA));
                for (Tag bee : beeList) {
                    String beeType = ((CompoundTag)bee).m_128461_("entity");
                    list.add((Component)new TextComponent(beeType).m_130940_(ChatFormatting.GOLD));
                }
            } else {
                list.add((Component)new TranslatableComponent("productivebees.information.hold_shift").m_130940_(ChatFormatting.WHITE));
            }
        }
    }
}

