/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class BeeCage
extends Item {
    public BeeCage(Item.Properties properties) {
        super(properties);
    }

    public static boolean isFilled(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return !itemStack.m_41619_() && tag != null && tag.m_128441_("entity");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level playerWorld = context.m_43723_().m_20193_();
        ItemStack stack = context.m_43722_();
        if (playerWorld.m_5776_() || !BeeCage.isFilled(stack)) {
            return InteractionResult.FAIL;
        }
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Bee entity = BeeCage.getEntityFromStack(stack, worldIn, true);
        if (entity != null) {
            if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
                entity.f_27698_ = null;
            }
            BlockPos blockPos = pos.m_142300_(context.m_43719_());
            entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            worldIn.m_7967_((Entity)entity);
            this.postItemUse(context);
        }
        return InteractionResult.SUCCESS;
    }

    protected void postItemUse(UseOnContext context) {
        if (context.m_43723_() != null) {
            context.m_43723_().m_150109_().m_36057_(context.m_43722_());
        }
    }

    @Nonnull
    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity targetIn, InteractionHand hand) {
        if (targetIn.m_20193_().m_5776_() || !(targetIn instanceof Bee) || !targetIn.m_6084_() || BeeCage.isFilled(itemStack)) {
            return InteractionResult.PASS;
        }
        Bee target = (Bee)targetIn;
        boolean addToInventory = true;
        ItemStack cageStack = new ItemStack((ItemLike)itemStack.m_41720_());
        if (itemStack.m_41613_() == 1) {
            cageStack = itemStack;
            addToInventory = false;
        }
        BeeCage.captureEntity(target, cageStack);
        if (addToInventory || player.m_7500_()) {
            if (!player.m_150109_().m_36054_(cageStack)) {
                player.m_36176_(cageStack, false);
            }
            itemStack.m_41774_(1);
        }
        player.m_6674_(hand);
        if (player instanceof ServerPlayer) {
            ModAdvancements.CATCH_BEE.trigger((ServerPlayer)player, cageStack);
        }
        target.m_146870_();
        return InteractionResult.SUCCESS;
    }

    public static void captureEntity(Bee target, ItemStack cageStack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
        if (target.m_8077_()) {
            nbt.m_128359_("name", target.m_7770_().getString());
        } else {
            nbt.m_128359_("name", target.m_7755_().getString());
        }
        target.m_20240_(nbt);
        nbt.m_128473_("Motion");
        nbt.m_128473_("Pos");
        nbt.m_128473_("Rotation");
        nbt.m_128379_("isProductiveBee", target instanceof ProductiveBee);
        String modId = target.m_6095_().getRegistryName().m_135827_();
        String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        nbt.m_128359_("mod", modName);
        cageStack.m_41751_(nbt);
    }

    @Nullable
    public static Bee getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        return BeeCage.getEntityFromStack(stack.m_41783_(), world, withInfo);
    }

    @Nullable
    public static Bee getEntityFromStack(@Nullable CompoundTag tag, Level world, boolean withInfo) {
        EntityType type;
        if (tag != null && (type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entity")).orElse(null)) != null) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(tag);
            }
            if (entity instanceof Bee) {
                if (entity instanceof ConfigurableBee && !withInfo) {
                    ((ConfigurableBee)entity).setBeeType(tag.m_128461_("type"));
                }
                return (Bee)entity;
            }
        }
        return null;
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        if (!BeeCage.isFilled(stack)) {
            return new TranslatableComponent(this.m_5524_());
        }
        String entityId = stack.m_41783_().m_128461_("name");
        return new TranslatableComponent(this.m_5524_()).m_7220_((Component)new TextComponent(" (" + entityId + ")"));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && !tag.equals((Object)new CompoundTag())) {
            if (Screen.m_96638_()) {
                boolean hasStung = tag.m_128471_("HasStung");
                if (hasStung) {
                    list.add((Component)new TranslatableComponent("productivebees.information.health.dying").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
                }
                BeeHelper.populateBeeInfoFromTag(tag, list);
            } else {
                list.add((Component)new TranslatableComponent("productivebees.information.hold_shift").m_130940_(ChatFormatting.WHITE));
            }
        }
    }
}

