/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.DragonEggHiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;

public class AdvancedBeehiveScreen
extends AbstractContainerScreen<AdvancedBeehiveContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive.png");
    private static final ResourceLocation GUI_TEXTURE_EXPANDED = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive_expanded.png");

    public AdvancedBeehiveScreen(AdvancedBeehiveContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        boolean expanded = ((AdvancedBeehiveContainer)this.f_97732_).tileEntity.m_58900_().m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, expanded ? -5.0f : 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, ((AdvancedBeehiveContainer)this.f_97732_).tileEntity.m_5446_(), expanded ? -5.0f : 8.0f, (float)(this.getYSize() - 96 + 2), 0x404040);
        assert (this.f_96541_ != null);
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        ((AdvancedBeehiveContainer)this.f_97732_).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int j = 0;
            for (AdvancedBeehiveBlockEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                BeeIngredient beeIngredient;
                CompoundTag nbt = inhabitant.nbt;
                Entity bee = null;
                String type = inhabitant.nbt.m_128461_("type");
                if (type.isEmpty()) {
                    type = inhabitant.nbt.m_128461_("id");
                }
                if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                    bee = beeIngredient.getCachedEntity((Level)this.f_96541_.f_91073_);
                }
                if (bee == null || bee.m_20078_() == null) continue;
                if (bee instanceof ConfigurableBee && nbt.m_128441_("type")) {
                    ((ConfigurableBee)bee).setBeeType(nbt.m_128461_("type"));
                }
                if (positions.containsKey(j) && this.m_6774_((Integer)((List)positions.get(j)).get(0) - (expanded ? 13 : 0), (Integer)((List)positions.get(j)).get(1), 16, 16, mouseX, mouseY)) {
                    CompoundTag tag = inhabitant.nbt.m_6426_();
                    ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
                    tooltipList.add(bee.m_7755_().m_7532_());
                    if (Screen.m_96638_()) {
                        String modId = new ResourceLocation(bee.m_20078_()).m_135827_();
                        if (modId.equals("productivebees")) {
                            tag.m_128379_("isProductiveBee", true);
                        }
                        List<Component> list = BeeHelper.populateBeeInfoFromTag(tag, null);
                        for (Component textComponent : list) {
                            tooltipList.add(textComponent.m_7532_());
                        }
                        if (!tag.m_128471_("isProductiveBee")) {
                            String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
                            if (modId.equals("minecraft")) {
                                modName = "Minecraft";
                            }
                            tooltipList.add(new TextComponent(modName).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BLUE).m_7532_());
                        }
                    } else {
                        tooltipList.add(new TranslatableComponent("productivebees.information.hold_shift").m_130940_(ChatFormatting.WHITE).m_7532_());
                    }
                    this.m_96617_(matrixStack, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
                }
                ++j;
            }
        });
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        boolean expanded = ((AdvancedBeehiveContainer)this.f_97732_).tileEntity.m_58900_().m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(expanded ? GUI_TEXTURE_EXPANDED : GUI_TEXTURE));
        int honeyLevel = (Integer)((AdvancedBeehiveContainer)this.f_97732_).tileEntity.m_58900_().m_61143_((Property)BeehiveBlock.f_49564_);
        this.m_93228_(matrixStack, this.getGuiLeft() - (expanded ? 13 : 0), this.getGuiTop(), 0, 0, this.getXSize() + (expanded ? 26 : 0), this.getYSize());
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        int xOffset = ((AdvancedBeehiveContainer)this.f_97732_).tileEntity instanceof DragonEggHiveBlockEntity ? 13 : 0;
        this.m_93228_(matrixStack, this.getGuiLeft() + 87 - (expanded ? 13 : 0), this.getGuiTop() + 37, 202 + xOffset, honeyLevel * 13, 13, 13);
        ((AdvancedBeehiveContainer)this.f_97732_).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int i = 0;
            for (AdvancedBeehiveBlockEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                if (this.f_96541_.f_91074_ != null && positions.containsKey(i)) {
                    BeeIngredient beeIngredient;
                    String type = inhabitant.nbt.m_128461_("type");
                    if (type.isEmpty()) {
                        type = inhabitant.nbt.m_128461_("id");
                    }
                    if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                        BeeRenderer.render(matrixStack, this.getGuiLeft() + (Integer)((List)positions.get(i)).get(0) - (expanded ? 13 : 0), this.getGuiTop() + (Integer)((List)positions.get(i)).get(1), beeIngredient, this.f_96541_);
                    }
                }
                ++i;
            }
        });
    }
}

