/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

class FluidContainerUtil {
    FluidContainerUtil() {
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void setColors(int color) {
        RenderSystem.m_157429_((float)FluidContainerUtil.getRed(color), (float)FluidContainerUtil.getGreen(color), (float)FluidContainerUtil.getBlue(color), (float)FluidContainerUtil.getAlpha(color));
    }

    public static void setColors(@Nonnull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            FluidContainerUtil.setColors(fluid.getFluid().getAttributes().getColor(fluid));
        }
    }

    public static void resetColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        if (desiredWidth != 0 && desiredHeight != 0 && textureWidth != 0 && textureHeight != 0) {
            FluidContainerUtil.bindTexture(TextureAtlas.f_118259_);
            int xTileCount = desiredWidth / textureWidth;
            int xRemainder = desiredWidth - xTileCount * textureWidth;
            int yTileCount = desiredHeight / textureHeight;
            int yRemainder = desiredHeight - yTileCount * textureHeight;
            int yStart = yPosition + yOffset;
            float uMin = sprite.m_118409_();
            float uMax = sprite.m_118410_();
            float vMin = sprite.m_118411_();
            float vMax = sprite.m_118412_();
            float uDif = uMax - uMin;
            float vDif = vMax - vMin;
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
            vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                int width;
                int n = width = xTile == xTileCount ? xRemainder : textureWidth;
                if (width == 0) break;
                int x = xPosition + xTile * textureWidth;
                int maskRight = textureWidth - width;
                int shiftedX = x + textureWidth - maskRight;
                float uMaxLocal = uMax - uDif * (float)maskRight / (float)textureWidth;
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int height;
                    int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                    if (height == 0) continue block0;
                    int y = yStart - (yTile + 1) * textureHeight;
                    int maskTop = textureHeight - height;
                    float vMaxLocal = vMax - vDif * (float)maskTop / (float)textureHeight;
                    vertexBuffer.m_5483_((double)x, (double)(y + textureHeight), (double)zLevel).m_7421_(uMin, vMaxLocal).m_5752_();
                    vertexBuffer.m_5483_((double)shiftedX, (double)(y + textureHeight), (double)zLevel).m_7421_(uMaxLocal, vMaxLocal).m_5752_();
                    vertexBuffer.m_5483_((double)shiftedX, (double)(y + maskTop), (double)zLevel).m_7421_(uMaxLocal, vMin).m_5752_();
                    vertexBuffer.m_5483_((double)x, (double)(y + maskTop), (double)zLevel).m_7421_(uMin, vMin).m_5752_();
                }
            }
            vertexBuffer.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)vertexBuffer);
            RenderSystem.m_69465_();
            RenderSystem.m_69461_();
        }
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(spriteLocation);
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.m_91087_().f_90987_.m_174784_(texture);
    }
}

