/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        Level world;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.m_41619_() && entity instanceof Bee && (world = entityInteract.getWorld()) instanceof ServerLevel) {
            Player player = entityInteract.getPlayer();
            BlockPos pos = entity.m_142538_();
            Entity newBee = BeeHelper.itemInteract((Bee)entity, itemStack, (ServerLevel)world, entity.serializeNBT(), player);
            if (newBee != null) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.m_7967_(newBee);
                entity.m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getResultStack();
        if (stack.m_41720_().equals(Items.f_42787_)) {
            LivingEntity entity = event.getEntityLiving();
            if (!entity.m_20193_().f_46443_ && entity.m_20193_().f_46441_.nextBoolean()) {
                entity.curePotionEffects(stack);
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_().equals(Blocks.f_50262_) && (Integer)event.getState().m_61143_((Property)CocoaBlock.f_51736_) == 2) {
            Player player = event.getPlayer();
            Level world = player.f_19853_;
            if (world instanceof ServerLevel && player instanceof ServerPlayer && (double)ProductiveBees.rand.nextFloat() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
                ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(world);
                BlockPos pos = event.getPos();
                if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:sugarbag") != null) {
                    bee.setBeeType("productivebees:sugarbag");
                    bee.setAttributes();
                    bee.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    world.m_5594_(player, pos, SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    world.m_7967_((Entity)bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootSetup(LootTableLoadEvent event) {
        if (event.getName().toString().contains("chests/village")) {
            event.getTable().getPool((String)"main").f_79023_.add(LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STURDY_BEE_CAGE.get())).m_79707_(4).m_7512_());
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.m_20675_().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().m_22265_());
    }
}

