/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.gen.feature.CavernSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.OreSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.ReedSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.StructureSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.WoodSolitaryNestFeature;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import java.util.function.Supplier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"productivebees");
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SAND_NEST = ModFeatures.register("sand_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SNOW_NEST = ModFeatures.register("snow_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> STONE_NEST = ModFeatures.register("stone_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> COARSE_DIRT_NEST = ModFeatures.register("coarse_dirt_nest", () -> new SolitaryNestFeature(0.3f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> GRAVEL_NEST = ModFeatures.register("gravel_nest", () -> new SolitaryNestFeature(0.15f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SLIMY_NEST = ModFeatures.register("slimy_nest", () -> new SolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SUGAR_CANE_NEST = ModFeatures.register("sugar_cane_nest", () -> new ReedSolitaryNestFeature(0.4f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> GLOWSTONE_NEST = ModFeatures.register("glowstone_nest", () -> new CavernSolitaryNestFeature(0.9f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, false));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> NETHER_QUARTZ_NEST = ModFeatures.register("nether_quartz_nest", () -> new OreSolitaryNestFeature(0.2f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, 10, 70));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> NETHER_QUARTZ_NEST_HIGH = ModFeatures.register("nether_quartz_nest_high", () -> new OreSolitaryNestFeature(0.7f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, 70, 100));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> NETHER_FORTRESS_NEST = ModFeatures.register("nether_fortress_nest", () -> new StructureSolitaryNestFeature(0.9f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, 35));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SOUL_SAND_NEST = ModFeatures.register("soul_sand_nest", () -> new CavernSolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> END_NEST = ModFeatures.register("end_nest", () -> new SolitaryNestFeature(0.15f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> OBSIDIAN_PILLAR_NEST = ModFeatures.register("obsidian_pillar_nest", () -> new StructureSolitaryNestFeature(1.0f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_, 25));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> BUMBLE_BEE_NEST = ModFeatures.register("bumble_bee_nest", () -> new SolitaryNestFeature(0.01f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> OAK_WOOD_NEST_FEATURE = ModFeatures.register("oak_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> SPRUCE_WOOD_NEST_FEATURE = ModFeatures.register("spruce_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> BIRCH_WOOD_NEST_FEATURE = ModFeatures.register("birch_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> DARK_OAK_WOOD_NEST_FEATURE = ModFeatures.register("dark_oak_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> JUNGLE_WOOD_NEST_FEATURE = ModFeatures.register("jungle_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));
    public static final RegistryObject<Feature<ReplaceBlockConfiguration>> ACACIA_WOOD_NEST_FEATURE = ModFeatures.register("acacia_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfiguration>)ReplaceBlockConfiguration.f_68023_));

    private static <E extends FeatureConfiguration> RegistryObject<Feature<E>> register(String name, Supplier<Feature<E>> supplier) {
        return FEATURES.register(name, supplier);
    }

    public static void registerFeatures(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        if (category.equals((Object)Biome.BiomeCategory.DESERT)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SAND_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.SAVANNA) || category.equals((Object)Biome.BiomeCategory.TAIGA)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.COARSE_DIRT_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SPRUCE_WOOD_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.ACACIA_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.JUNGLE)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.JUNGLE_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.FOREST)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.OAK_WOOD_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.DARK_OAK_WOOD_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.BIRCH_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.EXTREME_HILLS)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.STONE_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SNOW_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SNOW_NEST_BLOCK_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.SWAMP)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SLIMY_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.PLAINS)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.BUMBLE_BEE_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.NETHER)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModConfiguredFeatures.GLOWSTONE_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, ModConfiguredFeatures.NETHER_QUARTZ_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.NETHER_QUARTZ_NEST_HIGH_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.NETHER_FORTRESS_NEST_FEATURE);
            event.getGeneration().m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModConfiguredFeatures.SOUL_SAND_NEST_FEATURE);
        } else if (category.equals((Object)Biome.BiomeCategory.RIVER) || category.equals((Object)Biome.BiomeCategory.BEACH)) {
            if (event.getClimate().f_47682_ != Biome.TemperatureModifier.FROZEN) {
                event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.GRAVEL_NEST_FEATURE);
            }
        } else if (category.equals((Object)Biome.BiomeCategory.THEEND)) {
            if (event.getName().m_135815_().equals("the_end")) {
                event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.OBSIDIAN_PILLAR_NEST_FEATURE);
            } else {
                event.getGeneration().m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.END_NEST_FEATURE);
            }
        }
        if (!category.equals((Object)Biome.BiomeCategory.THEEND) && !category.equals((Object)Biome.BiomeCategory.NETHER)) {
            event.getGeneration().m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SUGAR_CANE_NEST_FEATURE);
        }
    }
}

