/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.hwyla;

import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import java.util.List;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

@WailaPlugin(value="productivebees")
public class ProductiveBeesHwylaPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((tooltip, accessor, config) -> {
            BlockEntity tileEntity$temp = accessor.getBlockEntity();
            if (!(tileEntity$temp instanceof SolitaryNestBlockEntity)) {
                return;
            }
            SolitaryNestBlockEntity tileEntity = (SolitaryNestBlockEntity)tileEntity$temp;
            List<AdvancedBeehiveBlockEntityAbstract.Inhabitant> bees = tileEntity.getBeeList();
            if (!bees.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.bee", new Object[]{bees.get((int)0).localizedName}));
            } else {
                int cooldown = tileEntity.getNestTickCooldown();
                if (cooldown > 0) {
                    tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown", new Object[]{Math.round((float)cooldown / 20.0f) + "s"}));
                } else {
                    tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown_inactive"));
                    if (tileEntity.canRepopulate()) {
                        tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_true"));
                    } else {
                        tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_false"));
                    }
                }
            }
        }, TooltipPosition.BODY, SolitaryNest.class);
    }
}

