/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;

public class BeeBreedingRecipeCategory
implements IRecipeCategory<BeeBreedingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeBreedingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_breeding_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)BeeIngredientFactory.getOrCreateList().get("productivebees:quarry_bee"));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BEE_BREEDING_UID;
    }

    @Nonnull
    public Class<? extends BeeBreedingRecipe> getRecipeClass() {
        return BeeBreedingRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bee_breeding");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BeeBreedingRecipe recipe, IIngredients ingredients) {
        ArrayList<BeeIngredient> recipeIngredients = new ArrayList<BeeIngredient>();
        for (Lazy<BeeIngredient> ingredient : recipe.ingredients) {
            recipeIngredients.add((BeeIngredient)ingredient.get());
        }
        ArrayList<BeeIngredient> recipeOutputs = new ArrayList<BeeIngredient>();
        for (Map.Entry<Lazy<BeeIngredient>, Integer> ingredient : recipe.offspring.entrySet()) {
            recipeOutputs.add((BeeIngredient)ingredient.getKey().get());
        }
        ingredients.setInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, recipeIngredients);
        ingredients.setOutputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, recipeOutputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BeeBreedingRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        ingredientStacks.init(0, true, 8, 27);
        ingredientStacks.init(1, true, 42, 27);
        ingredientStacks.init(2, false, 100, 27);
        ingredientStacks.set(ingredients);
    }
}

