/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.BlockConversionRecipe;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class BlockConversionRecipeCategory
implements IRecipeCategory<BlockConversionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BlockConversionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/block_conversion.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 90, 52);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_42594_));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BLOCK_CONVERSION_UID;
    }

    @Nonnull
    public Class<? extends BlockConversionRecipe> getRecipeClass() {
        return BlockConversionRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.block_conversion");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BlockConversionRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, Collections.singletonList((BeeIngredient)recipe.bee.get()));
        if (recipe.stateFrom.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            ingredients.setInputs(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((ItemLike)recipe.stateFrom.m_60734_().m_5456_())));
        } else {
            ingredients.setInputs(VanillaTypes.FLUID, Collections.singletonList(new FluidStack(recipe.stateFrom.m_60819_().m_76152_(), 1000)));
        }
        if (recipe.stateTo.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            ingredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((ItemLike)recipe.stateTo.m_60734_().m_5456_())));
        } else {
            ingredients.setOutputs(VanillaTypes.FLUID, Collections.singletonList(new FluidStack(recipe.stateTo.m_60819_().m_76152_(), 1000)));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, BlockConversionRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup beeIngredients = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        beeIngredients.init(0, true, 38, 5);
        beeIngredients.set(ingredients);
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        if (recipe.stateFrom.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            itemStacks.init(1, true, 5, 25);
        } else {
            fluidStacks.init(1, true, 5, 26);
        }
        if (recipe.stateTo.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            itemStacks.init(2, false, 65, 25);
        } else {
            fluidStacks.init(2, false, 65, 26);
        }
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
    }
}

