/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.NBTIngredient;

public class IncubationRecipeCategory
implements IRecipeCategory<IncubationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public IncubationRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/incubator.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_INCUBATION_UID;
    }

    @Nonnull
    public Class<? extends IncubationRecipe> getRecipeClass() {
        return IncubationRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.incubation");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IncubationRecipe recipe, IIngredients ingredients) {
        List<ItemStack> inputs = Arrays.asList(recipe.input.m_43908_());
        List<ItemStack> catalyst = Arrays.asList(recipe.catalyst.m_43908_());
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(inputs, catalyst));
        ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.result.m_43908_()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IncubationRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 8, 8);
        itemStacks.init(1, true, 36, 26);
        itemStacks.init(2, false, 64, 8);
        itemStacks.set(ingredients);
    }

    public static List<IncubationRecipe> getRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<IncubationRecipe> recipes = new ArrayList<IncubationRecipe>();
        Bee bee = (Bee)EntityType.f_20550_.m_20615_(ProductiveBees.proxy.getWorld());
        Bee baBee = (Bee)EntityType.f_20550_.m_20615_(ProductiveBees.proxy.getWorld());
        if (bee != null && baBee != null) {
            ItemStack cage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
            ItemStack babeeCage = cage.m_41777_();
            baBee.m_146762_(-24000);
            BeeCage.captureEntity(bee, cage);
            BeeCage.captureEntity(baBee, babeeCage);
            ItemStack treats = new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), ((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
            recipes.add(new IncubationRecipe(new ResourceLocation("productivebees", "cage_incubation"), Ingredient.m_43927_((ItemStack[])new ItemStack[]{babeeCage}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{treats}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{cage})));
        }
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            Ingredient spawnEgg = NBTIngredient.m_43927_((ItemStack[])new ItemStack[]{BeeCreator.getSpawnEgg(entry.getKey())});
            Ingredient treat = NBTIngredient.m_43927_((ItemStack[])new ItemStack[]{HoneyTreat.getTypeStack(entry.getKey(), 100)});
            recipes.add(new IncubationRecipe(new ResourceLocation(entry.getKey() + "_incubation"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), treat, spawnEgg));
        }
        return recipes;
    }
}

