/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.network.packets;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class Messages {
    private static void updateJEI() {
        ProductiveBees.LOGGER.info("Calling updateJEI");
        block10: for (ServerType type : ServerType.values()) {
            if (!type.connected()) continue;
            switch (type.name) {
                case "integrated": {
                    RecipeManager manager = ProductiveBees.proxy.getWorld().m_7465_();
                    ForgeHooksClient.onRecipesUpdated((RecipeManager)manager);
                    continue block10;
                }
                case "vanilla": {
                    MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent.VanillaTagTypes(ProductiveBees.proxy.getWorld().m_5999_()));
                    continue block10;
                }
                case "modded": {
                    MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent.CustomTagTypes(ProductiveBees.proxy.getWorld().m_5999_()));
                }
            }
        }
    }

    private static enum ServerType {
        INTEGRATED("integrated", false, true),
        VANILLA_REMOTE("vanilla", true, false),
        MODDED_REMOTE("modded", false, false);

        public final String name;
        public final boolean isVanilla;
        public final boolean isIntegrated;

        private ServerType(String name, boolean isVanilla, boolean isIntegrated) {
            this.name = name;
            this.isVanilla = isVanilla;
            this.isIntegrated = isIntegrated;
        }

        public boolean connected() {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            boolean isVanilla = connection != null && NetworkHooks.isVanillaConnection((Connection)connection.m_6198_());
            boolean isIntegrated = Minecraft.m_91087_().m_91091_();
            return isVanilla == this.isVanilla && isIntegrated == this.isIntegrated;
        }
    }

    public static class BeeDataMessage {
        public Map<String, CompoundTag> data;

        public BeeDataMessage(Map<String, CompoundTag> data) {
            this.data = data;
        }

        public static void encode(BeeDataMessage message, FriendlyByteBuf buffer) {
            ProductiveBees.LOGGER.info("BeeDataMessage encode");
            buffer.writeInt(message.data.size());
            for (Map.Entry<String, CompoundTag> entry : message.data.entrySet()) {
                buffer.m_130070_(entry.getKey());
                buffer.m_130079_(entry.getValue());
            }
        }

        public static BeeDataMessage decode(FriendlyByteBuf buffer) {
            ProductiveBees.LOGGER.info("BeeDataMessage decode");
            HashMap<String, CompoundTag> data = new HashMap<String, CompoundTag>();
            IntStream.range(0, buffer.readInt()).forEach(i -> data.put(buffer.m_130277_(), buffer.m_130261_()));
            return new BeeDataMessage(data);
        }

        public static void handle(BeeDataMessage message, Supplier<NetworkEvent.Context> context) {
            BeeReloadListener.INSTANCE.setData(message.data);
            ProductiveBees.LOGGER.info("bee data received " + message.data.size());
            context.get().setPacketHandled(true);
        }
    }
}

