/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeBreedingRecipe
implements Recipe<Container> {
    public static final RecipeType<BeeBreedingRecipe> BEE_BREEDING = RecipeType.m_44119_((String)"productivebees:bee_breeding");
    public final ResourceLocation id;
    public final List<Lazy<BeeIngredient>> ingredients;
    public final Map<Lazy<BeeIngredient>, Integer> offspring;

    public BeeBreedingRecipe(ResourceLocation id, List<Lazy<BeeIngredient>> ingredients, Map<Lazy<BeeIngredient>, Integer> offspring) {
        this.id = id;
        this.ingredients = ingredients;
        this.offspring = offspring;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory) {
            String beeName1 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String beeName2 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            for (Lazy<BeeIngredient> parent : this.ingredients) {
                if (parent.get() != null) {
                    String parentName = ((BeeIngredient)parent.get()).getBeeType().toString();
                    if (parentName.equals(beeName1) || parentName.equals(beeName2)) continue;
                    return false;
                }
                ProductiveBees.LOGGER.warn("Bee not found in breeding recipe " + this.id);
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_BREEDING.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return BEE_BREEDING;
    }

    public static class Serializer<T extends BeeBreedingRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String parentName1 = GsonHelper.m_13906_((JsonObject)json, (String)"parent1");
            String parentName2 = GsonHelper.m_13906_((JsonObject)json, (String)"parent2");
            LinkedHashMap<Lazy<BeeIngredient>, Integer> children = new LinkedHashMap<Lazy<BeeIngredient>, Integer>();
            JsonArray offspring = GsonHelper.m_13933_((JsonObject)json, (String)"offspring");
            offspring.forEach(el -> {
                if (el.isJsonObject()) {
                    String child = GsonHelper.m_13906_((JsonObject)el.getAsJsonObject(), (String)"offspring");
                    children.put(Lazy.of(BeeIngredientFactory.getIngredient(child)), GsonHelper.m_13927_((JsonObject)el.getAsJsonObject(), (String)"weight"));
                } else {
                    String child = el.getAsString();
                    children.put(Lazy.of(BeeIngredientFactory.getIngredient(child)), 1);
                }
            });
            Lazy beeIngredientParent1 = Lazy.of(BeeIngredientFactory.getIngredient(parentName1));
            Lazy beeIngredientParent2 = Lazy.of(BeeIngredientFactory.getIngredient(parentName2));
            return this.factory.create(id, Arrays.asList(beeIngredientParent1, beeIngredientParent2), children);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                ArrayList<Lazy<BeeIngredient>> ingredients = new ArrayList<Lazy<BeeIngredient>>();
                BeeIngredient ing1 = BeeIngredient.fromNetwork(buffer);
                BeeIngredient ing2 = BeeIngredient.fromNetwork(buffer);
                ingredients.add(Lazy.of(() -> ing1));
                ingredients.add(Lazy.of(() -> ing2));
                LinkedHashMap<Lazy<BeeIngredient>, Integer> offspring = new LinkedHashMap<Lazy<BeeIngredient>, Integer>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient result = BeeIngredient.fromNetwork(buffer);
                    offspring.put(Lazy.of(() -> result), buffer.readInt());
                });
                return this.factory.create(id, ingredients, offspring);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee breeding recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                for (Lazy<BeeIngredient> ingredient : ((BeeBreedingRecipe)recipe).ingredients) {
                    if (ingredient.get() != null) {
                        ((BeeIngredient)ingredient.get()).toNetwork(buffer);
                        continue;
                    }
                    throw new RuntimeException("Bee breeding recipe ingredient missing " + ((BeeBreedingRecipe)recipe).m_6423_() + " - " + ingredient);
                }
                buffer.writeInt(((BeeBreedingRecipe)recipe).offspring.size());
                ((BeeBreedingRecipe)recipe).offspring.forEach((child, weight) -> {
                    if (child.get() == null) {
                        throw new RuntimeException("Bee breeding recipe child missing " + recipe.m_6423_() + " - " + child);
                    }
                    ((BeeIngredient)child.get()).toNetwork(buffer);
                    buffer.writeInt(weight.intValue());
                });
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee breeding recipe to packet. " + ((BeeBreedingRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBreedingRecipe> {
            public T create(ResourceLocation var1, List<Lazy<BeeIngredient>> var2, Map<Lazy<BeeIngredient>, Integer> var3);
        }
    }
}

