/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlockConversionRecipe
implements Recipe<Container> {
    public static final RecipeType<BlockConversionRecipe> BLOCK_CONVERSION = RecipeType.m_44119_((String)"productivebees:block_conversion");
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> bee;
    public final BlockState stateFrom;
    public final BlockState stateTo;
    public final int chance;

    public BlockConversionRecipe(ResourceLocation id, Lazy<BeeIngredient> bee, BlockState from, BlockState to, int chance) {
        this.id = id;
        this.bee = bee;
        this.stateFrom = from;
        this.stateTo = to;
        this.chance = chance;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.BlockStateInventory && this.bee.get() != null) {
            String beeName = ((BeeHelper.BlockStateInventory)inv).getIdentifier(0);
            BlockState blockState = ((BeeHelper.BlockStateInventory)inv).getState();
            return ((BeeIngredient)this.bee.get()).getBeeType().toString().equals(beeName) && blockState.equals(this.stateFrom);
        }
        ProductiveBees.LOGGER.warn("conversion recipe source is null " + this);
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BLOCK_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return BLOCK_CONVERSION;
    }

    private static BlockState jsonToBlockState(JsonObject json) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", GsonHelper.m_13906_((JsonObject)json, (String)"Name"));
        if (json.has("Properties")) {
            CompoundTag propertyTag = new CompoundTag();
            JsonObject properties = GsonHelper.m_13930_((JsonObject)json, (String)"Properties");
            for (Map.Entry entry : properties.entrySet()) {
                propertyTag.m_128359_((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            tag.m_128365_("Properties", (Tag)propertyTag);
        }
        return NbtUtils.m_129241_((CompoundTag)tag);
    }

    public static class Serializer<T extends BlockConversionRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String source = GsonHelper.m_13906_((JsonObject)json, (String)"bee");
            Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
            BlockState from = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("from"));
            BlockState to = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("to"));
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)sourceBee, from, to, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                BlockState from = NbtUtils.m_129241_((CompoundTag)buffer.m_130261_());
                BlockState to = NbtUtils.m_129241_((CompoundTag)buffer.m_130261_());
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> source), from, to, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeIngredient)((BlockConversionRecipe)recipe).bee.get()).toNetwork(buffer);
                buffer.m_130079_(NbtUtils.m_129202_((BlockState)((BlockConversionRecipe)recipe).stateFrom));
                buffer.m_130079_(NbtUtils.m_129202_((BlockState)((BlockConversionRecipe)recipe).stateTo));
                buffer.writeInt(((BlockConversionRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BlockConversionRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BlockConversionRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, BlockState var3, BlockState var4, int var5);
        }
    }
}

